execute if score win match_variable matches 0 run function ctw:z_fct/match/stop

# Scores
scoreboard players reset blue_score match_variable
scoreboard players reset red_score match_variable
scoreboard players reset accelerated match_variable
scoreboard players set win match_variable 0
scoreboard players reset blue_buff_type match_variable
scoreboard players reset red_buff_type match_variable
scoreboard players reset set_rng lobby_variable
scoreboard players reset map_state lobby_variable
scoreboard players set gain_coin tick_cycle 1
scoreboard players set match_duration tick_count 0
scoreboard players set blue_buff_level match_variable 0
scoreboard players set red_buff_level match_variable 0

scoreboard players reset blue_worshippers_killed match_variable
scoreboard players reset cyan_worshippers_killed match_variable
scoreboard players reset red_worshippers_killed match_variable
scoreboard players reset pink_worshippers_killed match_variable

scoreboard players reset blue_wool match_variable
scoreboard players reset cyan_wool match_variable
scoreboard players reset red_wool match_variable
scoreboard players reset pink_wool match_variable

scoreboard players add match_count lobby_variable 1
scoreboard players operation @a match_in = match_count lobby_variable

# Preparation
scoreboard players operation preparation tick_count = preparation CONSTANT
execute store result bossbar ctw:preparation max run scoreboard players get preparation CONSTANT
execute store result bossbar ctw:preparation value run scoreboard players get preparation CONSTANT
bossbar set ctw:preparation visible true
bossbar set ctw:launching visible false
bossbar set ctw:preparation players @a

# Remove platform
fill -11 150 -11 11 152 11 minecraft:air

# World
time set noon
gamerule mobGriefing true
gamerule fallDamage true
gamerule announceAdvancements false
worldborder set 400

# Stats
scoreboard objectives remove total_kills
scoreboard objectives add total_kills playerKillCount {"text":"Total kills","bold":true,"color":"yellow","type":"text"}
scoreboard objectives remove total_deaths
scoreboard objectives add total_deaths deathCount {"text":"Total deaths","bold":true,"color":"yellow","type":"text"}
scoreboard objectives remove players_scores
scoreboard objectives add players_scores dummy {"text":"Players scores","bold":true,"color":"yellow","type":"text"}

# Warnings
bossbar set ctw:blue_warning visible false
bossbar set ctw:red_warning visible false

# Players
scoreboard objectives setdisplay list hearts
scoreboard players reset total_players match_variable
scoreboard players reset total_blue match_variable
scoreboard players reset total_red match_variable
tag @a[team=blue] add playing
tag @a[team=red] add playing
execute as @a[tag=playing] run scoreboard players add total_players match_variable 1
execute as @a[tag=playing,team=blue] run scoreboard players add total_blue match_variable 1
execute as @a[tag=playing,team=red] run scoreboard players add total_red match_variable 1
scoreboard players set @a[team=blue] current_team 1
scoreboard players set @a[team=red] current_team 2
execute as @a run function ctw:z_fct/match/player_management/player_setup

# Crystals
scoreboard players operation max_crystal_hp match_variable = crystal_hp_per_player CONSTANT
scoreboard players operation max_crystal_hp match_variable *= total_players match_variable
scoreboard players operation max_crystal_hp match_variable += base_crystal_hp CONSTANT

scoreboard players operation blue crystal_hp = max_crystal_hp match_variable
scoreboard players operation red crystal_hp = max_crystal_hp match_variable
execute store result bossbar ctw:blue_crystal max run scoreboard players get max_crystal_hp match_variable
execute store result bossbar ctw:red_crystal max run scoreboard players get max_crystal_hp match_variable
execute store result bossbar ctw:blue_crystal value run scoreboard players get blue crystal_hp
execute store result bossbar ctw:red_crystal value run scoreboard players get red crystal_hp
bossbar set ctw:blue_crystal visible true
bossbar set ctw:red_crystal visible true
bossbar set ctw:blue_crystal players @a
bossbar set ctw:red_crystal players @a

# Technical
setblock 2000 100 0 minecraft:oak_sign
scoreboard objectives add endinsp dummy

# NPCs
function ctw:z_fct/match/shop/adapt_traders
scoreboard objectives remove players_scores
scoreboard objectives add players_scores dummy {"text":"Players score","bold":true,"color":"yellow","type":"text"}
execute if score worshippers CONFIG matches 1 run scoreboard objectives setdisplay sidebar worshippers
execute if score worshippers CONFIG matches 0 run scoreboard objectives setdisplay sidebar players_scores
scoreboard objectives setdisplay list total_kills
scoreboard objectives setdisplay below_name hearts

# Shop
function ctw:z_fct/match/shop/spawn_blue_alts
function ctw:z_fct/match/shop/spawn_red_alts

# Wools
scoreboard players set blue lost_wool_delay -1
scoreboard players set cyan lost_wool_delay -1
scoreboard players set red lost_wool_delay -1
scoreboard players set pink lost_wool_delay -1

# Text
playsound minecraft:entity.experience_orb.pickup master @a 0 150 0 1 2 1
tellraw @a [{"text":"\u25b6 ","type":"text"},{"text":"Match started ! ","color":"green","bold":true,"type":"text"},{"text":"You will be able to leave your base in a moment, prepare your defense.","type":"text"}]
title @a times 0 20 20
title @a title {"text":"Go !","bold":true,"color":"white","type":"text"}

# Worshippers
execute unless entity @e[tag=blue_worshipper] run scoreboard players set missing_worshippers temp 1
execute unless entity @e[tag=cyan_worshipper] run scoreboard players set missing_worshippers temp 1
execute unless entity @e[tag=red_worshipper] run scoreboard players set missing_worshippers temp 1
execute unless entity @e[tag=pink_worshipper] run scoreboard players set missing_worshippers temp 1
execute if score worshippers CONFIG matches 1 if score missing_worshippers temp matches 1 run function ctw:z_fct/match/worshippers/spawn_worshippers
scoreboard players reset missing_worshippers temp
