tag @a[scores={died=1..}] add died
tag @a[scores={has_killed=1..}] add has_killed
tag @a[scores={sneaking=1..}] add sneaking
tag @a[scores={has_jumped=1..}] add has_jumped
tag @a[nbt={OnGround:1b}] add on_ground
#

# Spectators
execute positioned 5000 48 0 run gamemode spectator @a[tag=in_lobby]
execute positioned 5000 48 0 run tp @a[tag=in_lobby] 0 80 0

scoreboard players add match_duration tick_count 1
kill @e[type=minecraft:experience_orb]
effect clear @a[tag=on_ground] minecraft:slow_falling
execute if score t20 tick_cycle matches 1 run kill @e[type=minecraft:item,nbt={Item:{components:{"minecraft:custom_data":{default:1}}}}]

# FUNCTIONS

# Misc
execute if score t5 tick_cycle matches 1 run function ctw:z_fct/match/misc
function ctw:z_fct/match/economy/distribution
execute if score t10 tick_cycle matches 1 run function ctw:z_fct/match/shop/clear_specials
function ctw:z_fct/match/elements/axe_of_unity
function ctw:z_fct/match/elements/justice_trident
function ctw:z_fct/match/elements/mini_potion
function ctw:z_fct/match/elements/mossification
function ctw:z_fct/match/streak
effect clear @e[type=wandering_trader] minecraft:invisibility

# Changing teams
gamemode spectator @a[gamemode=survival,team=]
execute as @a[scores={current_team=2},team=blue] run function ctw:z_fct/match/player_management/go_blue_team
execute as @a[tag=!playing,team=blue] run function ctw:z_fct/match/player_management/go_blue_team
execute as @a[scores={current_team=1},team=red] run function ctw:z_fct/match/player_management/go_red_team
execute as @a[tag=!playing,team=red] run function ctw:z_fct/match/player_management/go_red_team
execute as @a[tag=playing,team=] run function ctw:z_fct/match/player_management/go_spectator
execute as @a[gamemode=spectator,tag=playing] run function ctw:z_fct/match/player_management/go_spectator

# Preparation
execute if score preparation tick_count matches 1 run bossbar set ctw:preparation visible false
execute if score preparation tick_count matches 1 run tellraw @a [{"text":"\u25b6 Preparation finished ! You can start bridging.","type":"text"}]
execute if score preparation tick_count matches 1 run tellraw @a[team=blue] [{"text":"\u25b6 Destroying the first ","type":"text"},{"text":"Red crystal","color":"red","type":"text"},{"text":" will enable your catapult and disable the Mining fatigue in the ","type":"text"},{"text":"Red base","color":"red","type":"text"},{"text":".","type":"text"}]
execute if score preparation tick_count matches 1 run tellraw @a[team=red] [{"text":"\u25b6 Destroying the first ","type":"text"},{"text":"Blue crystal","color":"blue","type":"text"},{"text":" will enable your catapult and disable the Mining fatigue in the ","type":"text"},{"text":"Blue base","color":"blue","type":"text"},{"text":".","type":"text"}]
execute if score match_duration tick_count matches 60.. if score preparation tick_count matches 1.. run tp @a[tag=!in_blue_base,team=blue] 0 54 -132 0 0
execute if score match_duration tick_count matches 60.. if score preparation tick_count matches 1.. run tp @a[tag=!in_red_base,team=red] 0 54 132 180 0
execute if score preparation tick_count matches 1.. run scoreboard players remove preparation tick_count 1
execute if score preparation tick_count matches 1.. store result bossbar ctw:preparation value run scoreboard players get preparation tick_count

# Wools
function ctw:z_fct/match/wools/blue_wool
function ctw:z_fct/match/wools/cyan_wool
function ctw:z_fct/match/wools/red_wool
function ctw:z_fct/match/wools/pink_wool
execute if score t10 tick_cycle matches 5 run function ctw:z_fct/match/wools/wool_explosion
execute if score t20 tick_cycle matches 1 run function ctw:z_fct/match/wools/missing_wool_check

# Elements
function ctw:z_fct/match/elements/elevator
function ctw:z_fct/match/buffs/buff_zone
function ctw:z_fct/match/crystals/tick_crystal
function ctw:z_fct/match/def_tower/tick_def_tower
execute if score worshippers CONFIG matches 1 run function ctw:z_fct/match/worshippers/tick_worshippers
function ctw:z_fct/match/elements/catapult

# Duration
execute if score accelerated match_variable matches 1 run effect give @a[tag=playing] minecraft:speed 2 2 true
scoreboard players operation alert temp = overtime CONSTANT
scoreboard players operation alert temp -= 2400 NUM
execute if score alert temp = match_duration tick_count run tellraw @a [{"text":"\u25b6 Acceleration in 2 minutes !","type":"text"}]
scoreboard players operation alert temp -= 3600 NUM
execute if score alert temp = match_duration tick_count run tellraw @a [{"text":"\u25b6 Acceleration in 5 minutes !","type":"text"}]
scoreboard players operation alert temp -= 6000 NUM
execute if score alert temp = match_duration tick_count run tellraw @a [{"text":"\u25b6 Acceleration in 10 minutes !","type":"text"}]
execute unless score accelerated match_variable matches 1 if score match_duration tick_count >= overtime CONSTANT run function ctw:z_fct/match/acceleration

# Respawn
execute as @a[tag=died] run function ctw:z_fct/match/player_management/respawn

# Detect kill
execute at @a[scores={killed_worshipper=1..}] run playsound minecraft:block.bell.use master @a ~ ~ ~ 2 0.7 1
scoreboard players reset @a killed_worshipper

#
scoreboard players reset @a died
scoreboard players reset @a has_killed
tag @a remove has_killed
scoreboard players reset @a sneaking
tag @a remove sneaking
scoreboard players reset @a has_jumped
tag @a remove has_jumped
tag @a remove on_ground
