/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.controllers;

import com.maniacobra.pyzzle.controllers.ExerciseNodes;
import com.maniacobra.pyzzle.models.ExerciseConfig;
import com.maniacobra.pyzzle.models.ExerciseManager;
import com.maniacobra.pyzzle.models.ExerciseModel;
import com.maniacobra.pyzzle.models.Word;
import com.maniacobra.pyzzle.properties.AppSettings;
import com.maniacobra.pyzzle.resources.CodeRunner;
import com.maniacobra.pyzzle.utils.TextUtils;
import com.maniacobra.pyzzle.views.PyzzleMain;
import com.maniacobra.pyzzle.views.blockeditor.BlockEditor;
import com.maniacobra.pyzzle.views.blockeditor.WordBlock;
import java.util.ArrayList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ExerciseController {
    private ExerciseModel model = new ExerciseModel();
    @FXML
    private TextFlow textFlowConsole;
    @FXML
    private TextArea textAreaCode;
    @FXML
    private TextFlow textFlowObjectives;
    @FXML
    private Text textNumber;
    @FXML
    private Text textName;
    @FXML
    private Text textCompletion;
    @FXML
    private Text textAttempts;
    @FXML
    private Text textScore;
    @FXML
    private Label labelUserName;
    @FXML
    private Button buttonExecution;
    @FXML
    private Button buttonReset;
    @FXML
    private Button buttonPrevious;
    @FXML
    private Button buttonNext;
    @FXML
    private Button buttonSolution;
    @FXML
    private Canvas canvasCodeEditor;
    @FXML
    private Canvas canvasWordSelection;
    @FXML
    private AnchorPane anchorPane;
    private ExerciseManager manager = null;
    private ExerciseNodes nodes;
    private BlockEditor codeEditor;
    private BlockEditor wordSelection;
    private WordBlock selectedBlock = null;
    private Canvas blockCanvas = null;
    private int mouseX = 0;
    private int mouseY = 0;

    public void initialize() {
        this.nodes = new ExerciseNodes(this.textAreaCode, this.textFlowConsole, this.textFlowObjectives, this.textNumber, this.textName, this.textCompletion, this.textAttempts, this.textScore, this.buttonExecution, this.buttonReset, this.buttonPrevious, this.buttonNext, this.buttonSolution);
        this.setEditors();
        this.anchorPane.addEventFilter(MouseEvent.MOUSE_MOVED, this::updateMouse);
        this.anchorPane.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::updateMouse);
        this.anchorPane.addEventFilter(MouseEvent.MOUSE_PRESSED, this::updateMouse);
        this.anchorPane.addEventFilter(MouseEvent.MOUSE_RELEASED, this::updateMouse);
        this.anchorPane.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            if (!AppSettings.getInstance().dragAndDrop && this.blockCanvas != null) {
                if (mouseEvent.getButton() == MouseButton.PRIMARY && this.codeEditor.insertWord(this.selectedBlock.getWord())) {
                    this.updateCode();
                } else {
                    this.wordSelection.returnWord(this.selectedBlock.getWord());
                    this.wordSelection.draw();
                }
                this.removeSelection();
            }
        });
        this.anchorPane.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            if (AppSettings.getInstance().dragAndDrop && this.blockCanvas != null && mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (this.codeEditor.insertWord(this.selectedBlock.getWord())) {
                    this.updateCode();
                } else {
                    this.wordSelection.returnWord(this.selectedBlock.getWord());
                    this.wordSelection.draw();
                }
                this.removeSelection();
            }
        });
    }

    @FXML
    public void runCode() {
        this.textFlowConsole.getChildren().clear();
        this.codeEditor.setHighlightedLines(CodeRunner.getInstance().getErrorLines());
        if (this.model.proceedExecution(this.nodes)) {
            this.lock();
        }
        this.codeEditor.draw();
        if (AppSettings.getInstance().autoSave) {
            this.manager.saveData();
        }
    }

    @FXML
    public void reset() {
        this.setEditors();
        this.removeSelection();
        this.textAreaCode.clear();
    }

    @FXML
    public void goToNext() {
        if (this.manager != null && this.model.isLocked()) {
            this.manager.goToExercise((BorderPane)this.anchorPane.getParent(), this.model.getExerciseNumber() + 1);
        }
    }

    @FXML
    public void goToPrevious() {
        if (this.manager != null) {
            this.manager.goToExercise((BorderPane)this.anchorPane.getParent(), this.model.getExerciseNumber() - 1);
        }
    }

    @FXML
    public void displaySolution() {
        if (!this.model.isLocked()) {
            return;
        }
        this.setEditors();
        this.model.switchSolution();
        ArrayList<ArrayList<Word>> solution = this.model.getSolutionOrPlaced();
        this.codeEditor.lock(this.model.isSolutionDisplayed());
        this.wordSelection.lock(this.model.isSolutionDisplayed());
        this.codeEditor.fill(solution);
        for (ArrayList<Word> line : solution) {
            for (Word word : line) {
                this.wordSelection.decountWord(word.getId());
            }
        }
        this.wordSelection.draw();
        this.updateCode();
        if (!this.model.isSolutionDisplayed()) {
            this.buttonSolution.setText("Voir la solution");
        } else {
            this.buttonSolution.setText("Retour");
        }
    }

    private void updateMouse(MouseEvent mouseEvent) {
        this.mouseX = (int)mouseEvent.getX();
        this.mouseY = (int)mouseEvent.getY();
        if (this.blockCanvas != null) {
            this.positionSelectedBlock();
            Node picked = mouseEvent.getPickResult().getIntersectedNode();
            if (picked != null && picked.equals(this.canvasCodeEditor)) {
                this.codeEditor.previewPosition(this.mouseX, this.mouseY);
            } else {
                this.codeEditor.stopPreview();
            }
        }
    }

    private void setEditors() {
        if (this.codeEditor != null) {
            this.codeEditor.delete();
        }
        if (this.wordSelection != null) {
            this.wordSelection.delete();
        }
        this.codeEditor = new BlockEditor(this.canvasCodeEditor, this, true);
        this.wordSelection = new BlockEditor(this.canvasWordSelection, this, false);
        this.wordSelection.fill(this.model.getWords());
        this.codeEditor.draw();
    }

    public void setSelectedBlock(WordBlock block) {
        if (this.model.isLocked()) {
            return;
        }
        this.anchorPane.getChildren().remove(this.blockCanvas);
        this.blockCanvas = new Canvas(block.getWidthNoUsage() + 3, 24.0);
        this.selectedBlock = new WordBlock(block.getWord().getCopy(true), 1, 1, this.blockCanvas.getGraphicsContext2D(), false);
        this.anchorPane.getChildren().add(this.blockCanvas);
        this.selectedBlock.draw(this.blockCanvas.getGraphicsContext2D());
        this.blockCanvas.setMouseTransparent(true);
        this.blockCanvas.setOpacity(0.7);
        this.positionSelectedBlock();
    }

    public void updateCode() {
        this.textAreaCode.setText(this.codeEditor.getFullText());
        this.model.setIdsPlaced(this.codeEditor.getIds());
    }

    public void returnWord(WordBlock block) {
        this.wordSelection.returnWord(block.getWord());
        this.wordSelection.draw();
        this.textAreaCode.setText(this.codeEditor.getFullText());
    }

    public void quickInsertion(WordBlock block) {
        Word word = block.getWord().getCopy(true);
        if (PyzzleMain.isShiftPressed()) {
            this.codeEditor.quickNewLine(word);
        } else {
            this.codeEditor.quickInsertion(word);
        }
        this.updateCode();
    }

    public boolean hasSelectedBlock() {
        return this.selectedBlock != null;
    }

    public boolean loadConfig(ExerciseConfig config) {
        if (this.model.loadExercise(config, this.nodes)) {
            if (this.model.isLocked()) {
                this.lock();
            }
            this.wordSelection.fill(this.model.getWords());
            if (config.completion() != null) {
                this.codeEditor.fill(this.model.getSolutionOrPlaced());
                for (int id : this.model.getIdsPlaced()) {
                    this.wordSelection.decountWord(id);
                }
                this.wordSelection.draw();
                JSONArray resultText = (JSONArray)config.completion().get("result_text");
                if (resultText != null) {
                    for (Object obj : resultText) {
                        JSONObject text = (JSONObject)obj;
                        TextUtils.addToTextFlow(this.textFlowConsole, (String)text.get("text"), Color.web((String)text.get("color")), (Boolean)text.get("bold"));
                    }
                }
            }
            this.updateCode();
            return true;
        }
        this.model = new ExerciseModel();
        return false;
    }

    public ExerciseModel getModel() {
        return this.model;
    }

    public void setManger(ExerciseManager manager) {
        this.manager = manager;
    }

    public void clearMemory() {
        if (this.codeEditor != null) {
            this.codeEditor.delete();
        }
        if (this.wordSelection != null) {
            this.wordSelection.delete();
        }
        this.model = null;
        this.manager = null;
        System.gc();
    }

    public void updateScore(float score) {
        this.model.setTotalScore(score, this.nodes);
    }

    public void updateUserName(String userName) {
        this.labelUserName.setText(userName);
    }

    private void removeSelection() {
        if (this.blockCanvas != null) {
            this.anchorPane.getChildren().remove(this.blockCanvas);
            this.blockCanvas = null;
        }
        this.selectedBlock = null;
        this.codeEditor.stopPreview();
    }

    private void positionSelectedBlock() {
        int halfX = (int)(this.blockCanvas.getWidth() / 2.0);
        int halfY = (int)(this.blockCanvas.getHeight() / 2.0);
        int maxX = (int)(this.anchorPane.getWidth() - this.blockCanvas.getWidth() - 2.0);
        int maxY = (int)(this.anchorPane.getHeight() - this.blockCanvas.getHeight() - 2.0);
        int x = this.mouseX - halfX;
        int y = this.mouseY - halfY;
        if (x > maxX) {
            x = maxX;
        } else if (x < 0) {
            x = 0;
        }
        if (y > maxY) {
            y = maxY;
        } else if (y < 0) {
            y = 0;
        }
        this.blockCanvas.setLayoutX(x);
        this.blockCanvas.setLayoutY(y);
    }

    private void lock() {
        this.codeEditor.lock(false);
        this.wordSelection.lock(false);
        this.removeSelection();
    }
}

