/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.controllers;

import com.maniacobra.pyzzle.models.ExerciseManager;
import com.maniacobra.pyzzle.properties.AppSettings;
import com.maniacobra.pyzzle.utils.Utils;
import java.io.File;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class IntroController {
    @FXML
    Label labelRestriction;
    @FXML
    Label labelPackName;
    @FXML
    Label labelAuthor;
    @FXML
    TextField textfName;
    @FXML
    Label labelBrowse;
    @FXML
    TextField textfSavePath;
    @FXML
    Button buttonBrowse;
    @FXML
    Label labelExam;
    @FXML
    Button buttonStart;
    @FXML
    Label labelAttempts;
    private ExerciseManager manager;
    private boolean forceInfos = false;

    public void init(ExerciseManager manager, String packName, String author, boolean forceInfos, boolean examMode, int attemptsCount) {
        this.manager = manager;
        this.forceInfos = forceInfos;
        String userName = AppSettings.getInstance().userName;
        this.textfName.setText(userName);
        manager.setUserName(userName);
        if (!forceInfos) {
            this.labelRestriction.setVisible(false);
        }
        if (userName.isEmpty()) {
            this.labelBrowse.setDisable(forceInfos);
            this.buttonBrowse.setDisable(forceInfos);
        }
        this.buttonStart.setDisable(forceInfos);
        this.labelExam.setVisible(examMode);
        this.labelPackName.setVisible(!packName.isEmpty());
        this.labelPackName.setText(packName);
        this.labelAuthor.setVisible(!author.isEmpty());
        this.labelAuthor.setText("Pack d'exercices cr\u00e9\u00e9 par " + author);
        this.labelAttempts.setText("Ouverture n\u00b0" + attemptsCount);
    }

    @FXML
    public void updateTextInput() {
        boolean emptyName;
        this.manager.setUserName(this.textfName.getText());
        boolean bl = emptyName = this.textfName.getText().length() == 0;
        if (this.forceInfos) {
            this.labelBrowse.setDisable(emptyName);
            this.textfSavePath.setDisable(emptyName);
            this.buttonBrowse.setDisable(emptyName);
            this.buttonStart.setDisable(emptyName || !this.manager.hasSaveFile());
        }
    }

    @FXML
    public void browseFilesAndSave() {
        this.updateSettings();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialFileName(this.manager.getSaveFileSuggestion());
        File file = fileChooser.showSaveDialog((Window)Stage.getWindows().get(0));
        if (file != null) {
            if (this.manager.saveData(file)) {
                this.textfSavePath.setText(file.getPath());
            } else {
                Utils.systemAlert(Alert.AlertType.ERROR, "Erreur inconnue de Pyzzle", "Une erreur inconnue est survenue.\nEssayez de red\u00e9marrer le logiciel.");
            }
        }
        if (this.forceInfos) {
            this.buttonStart.setDisable(!this.manager.hasUserName() || !this.manager.hasSaveFile());
        }
    }

    @FXML
    public void startPack() {
        this.updateSettings();
        this.manager.startFirstExercise();
        this.manager.displayHelpIfIntro();
    }

    private void updateSettings() {
        AppSettings.getInstance().userName = this.textfName.getText();
        this.manager.setUserName(this.textfName.getText());
        AppSettings.getInstance().save();
    }
}

