/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.controllers;

import com.maniacobra.pyzzle.controllers.SettingsController;
import com.maniacobra.pyzzle.models.ExerciseManager;
import com.maniacobra.pyzzle.properties.AppSettings;
import com.maniacobra.pyzzle.properties.FilePaths;
import com.maniacobra.pyzzle.resources.CodeRunner;
import com.maniacobra.pyzzle.resources.PyzzAnalyzer;
import com.maniacobra.pyzzle.utils.Popups;
import com.maniacobra.pyzzle.utils.Utils;
import com.maniacobra.pyzzle.views.PyzzleMain;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class MainController {
    private final ExerciseManager manager = new ExerciseManager();
    @FXML
    private BorderPane borderPane;
    @FXML
    private MenuItem menuItemSave;
    @FXML
    private MenuItem menuItemQuickSave;
    @FXML
    private Button buttonContinue;

    @FXML
    public void menuOpenFile() {
        CodeRunner.getInstance().pythonTest();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(FilePaths.getInstance().getPackFile());
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Fichier Pyzzle", List.of("pyzl", "spyzl"));
        fileChooser.setSelectedExtensionFilter(filter);
        File selectedFile = fileChooser.showOpenDialog((Window)Stage.getWindows().get(0));
        if (selectedFile != null && this.manager.openFile(selectedFile, this.borderPane)) {
            this.updateFileMenu();
        }
    }

    @FXML
    public void menuSave() {
        if (this.manager.isExamMode()) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialFileName(this.manager.getSaveFileSuggestion());
        File file = fileChooser.showSaveDialog((Window)Stage.getWindows().get(0));
        if (file != null) {
            this.manager.saveData(file);
            this.menuItemQuickSave.setDisable(false);
        }
    }

    @FXML
    public void updateFileMenu() {
        this.menuItemSave.setDisable(this.manager.isExamMode() || !this.manager.isLoaded());
        this.menuItemQuickSave.setDisable(!this.manager.hasSaveFile());
    }

    @FXML
    public void menuQuickSave() {
        this.manager.saveData();
    }

    @FXML
    public void menuAnalysis() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("S\u00e9lectionnez les fichiers spyzl");
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Fichier Pyzzle ouvert", List.of("spyzl")));
        List<File> files = fileChooser.showOpenMultipleDialog((Window)Stage.getWindows().get(0));
        if (!files.isEmpty() && !PyzzAnalyzer.getInstance().AnalyzeFiles(files)) {
            Utils.systemAlert(Alert.AlertType.ERROR, "Erreur de la correction", "Impossible de sauvegarder le fichier .csv ou l'analyse a \u00e9chou\u00e9e pour tous les fichiers.");
        }
    }

    @FXML
    public void menuSettings() {
        try {
            Pane returnPane;
            String returnText;
            FXMLLoader fxmlLoader = new FXMLLoader(PyzzleMain.class.getResource("settings-view.fxml"));
            Pane pane = (Pane)fxmlLoader.load();
            SettingsController controller = (SettingsController)fxmlLoader.getController();
            if (this.manager.isLoaded()) {
                returnText = "Retour \u00e0 l'exercice";
                returnPane = this.manager.getCurrentPane();
            } else {
                returnText = "Retour \u00e0 l'\u00e9cran d'accueil";
                returnPane = (Pane)this.borderPane.getCenter();
            }
            controller.init(returnPane, this.borderPane, returnText, this.manager.isExamMode());
            this.borderPane.setCenter(pane);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @FXML
    public void menuAbout() {
        Popups.showPopup("\u00c0 propos", "Pyzzle par Maniacobra", "\nVersion Prototype 1.0\n7 Avril 2024\n\nSite web : https://maniacobra.com\nContact mail : maniacobra@orange.fr\n\nLogiciel programm\u00e9 en Java (JavaFX), avec int\u00e9gration d'interpr\u00e9teur Python.\n\nCe programme est la version prototype d'un concept de logiciel \u00e9ducatif pour apprendre le Python.\nLa version compl\u00e8te du logiciel requiert de nombreuses nouveaut\u00e9s et am\u00e9liorations, le d\u00e9veloppement est \u00e0 ce jour interrompu.\n\nConsultez https://maniacobra.com/pyzzle pour v\u00e9rifier s'il existe une mise \u00e0 jour.\n", 550, 16, 55);
    }

    @FXML
    public void editorInfos() {
        Popups.showPopup("Informations sur l'\u00e9diteur", "Pyzzle ne propose pas encore d'\u00e9diteur graphique", "\nLa cr\u00e9ation et modification d'exercices peut se faire via l'\u00e9criture de fichiers au format .json, qui sont convertis en .pyzl par Pyzzle \u00e0 leur chargement.\n\nAllez sur le site maniacobra.com/pyzzle et t\u00e9l\u00e9chargez le pack de fichiers .pyzzle\n", 650, 16, 65);
    }

    @FXML
    public void openLastFile() {
        if (AppSettings.getInstance().lastOpenedPath == null) {
            return;
        }
        File file = new File(AppSettings.getInstance().lastOpenedPath);
        if (this.manager.openFile(file, this.borderPane)) {
            this.updateFileMenu();
        }
    }

    public void initialize() {
        if (PyzzleMain.getFileArg() != null && this.manager.openFile(PyzzleMain.getFileArg(), this.borderPane)) {
            this.updateFileMenu();
        }
        if (AppSettings.getInstance().lastOpenedPath == null && this.buttonContinue != null) {
            this.buttonContinue.setDisable(true);
        }
    }
}

