/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.controllers;

import com.maniacobra.pyzzle.properties.AppSettings;
import com.maniacobra.pyzzle.properties.FilePaths;
import com.maniacobra.pyzzle.resources.CodeRunner;
import com.maniacobra.pyzzle.utils.Utils;
import java.util.Arrays;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;

public class SettingsController {
    @FXML
    private Button buttonReturn;
    @FXML
    private TextField textfUserName;
    @FXML
    private CheckBox cbUpdateName;
    @FXML
    private CheckBox cbAutoSave;
    @FXML
    private CheckBox cbDragAndDrop;
    @FXML
    private RadioButton radioAutoArgs;
    @FXML
    private RadioButton radioCustomArgs;
    @FXML
    private TextField textfArgs;
    @FXML
    private Label labelArgs;
    private Pane returnPane = null;
    private BorderPane mainPane = null;

    @FXML
    public void quitSettings() {
        this.updateSettings();
        CodeRunner.getInstance().pythonTest();
        if (this.mainPane == null) {
            return;
        }
        this.mainPane.setCenter(this.returnPane);
        System.gc();
    }

    public void init(Pane returnPane, BorderPane mainPane, String returnText, boolean examMode) {
        this.returnPane = returnPane;
        this.mainPane = mainPane;
        this.buttonReturn.setText(returnText);
        this.updateUI();
        this.textfUserName.setDisable(examMode);
        this.cbUpdateName.setDisable(examMode);
        this.cbAutoSave.setDisable(examMode);
        if (FilePaths.getInstance().getPythonExePath() == null) {
            this.radioAutoArgs.setText("Trouver Python automatiquement sur le syst\u00e8me");
        }
    }

    @FXML
    public void updateSettings() {
        AppSettings settings = AppSettings.getInstance();
        settings.userName = this.textfUserName.getText();
        settings.updateName = this.cbUpdateName.isSelected();
        settings.autoSave = this.cbAutoSave.isSelected();
        settings.dragAndDrop = this.cbDragAndDrop.isSelected();
        settings.autoArgs = this.radioAutoArgs.isSelected();
        settings.terminalArgs.clear();
        settings.terminalArgs.addAll(Arrays.asList(this.textfArgs.getText().split(" ")));
        CodeRunner.getInstance().resetCommand();
        settings.save();
        this.updateUI();
    }

    @FXML
    public void checkPyzzle() {
        this.updateSettings();
        if (CodeRunner.getInstance().pythonTest()) {
            Utils.systemAlert(Alert.AlertType.INFORMATION, "Pyzzle fonctionne !", "L'ex\u00e9cution de Python par Pyzzle fonctionne correctement.\nArguments utilis\u00e9s :\n\n" + String.join((CharSequence)" ", CodeRunner.getInstance().getCommand()));
        }
    }

    private void updateUI() {
        AppSettings settings = AppSettings.getInstance();
        this.textfUserName.setText(settings.userName);
        this.cbUpdateName.setSelected(settings.updateName);
        this.cbAutoSave.setSelected(settings.autoSave);
        this.cbDragAndDrop.setSelected(settings.dragAndDrop);
        this.radioAutoArgs.setSelected(settings.autoArgs);
        this.radioCustomArgs.setSelected(!settings.autoArgs);
        this.textfArgs.setDisable(settings.autoArgs);
        this.labelArgs.setDisable(settings.autoArgs);
        this.textfArgs.setText(String.join((CharSequence)" ", settings.terminalArgs));
    }
}

