/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.models;

import javafx.scene.paint.Color;

public class Word {
    private final WordType type;
    private final String text;
    private int usages;
    private final int id;
    private static final Color[] typeColors = new Color[]{Color.LIGHTGRAY, Color.rgb(212, 189, 255), Color.rgb(255, 180, 177), Color.rgb(250, 247, 177), Color.LIGHTGRAY, Color.rgb(177, 199, 250), Color.rgb(213, 247, 210), Color.rgb(190, 190, 190), Color.rgb(245, 225, 239), Color.WHITE};

    public Word(WordType type, String text, int usages, int id) {
        this.type = type;
        this.text = text;
        this.usages = usages;
        this.id = id;
    }

    public boolean use() {
        if (this.usages > 0) {
            --this.usages;
        }
        return this.usages == 0;
    }

    public WordType getType() {
        return this.type;
    }

    public boolean merge(Word word) {
        if (word.id == this.id) {
            if (this.usages != -1) {
                ++this.usages;
            }
            return true;
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    public Word getCopy(boolean singleUse) {
        return new Word(this.type, this.text, singleUse ? 1 : this.usages, this.id);
    }

    public int getUsages() {
        return this.usages;
    }

    public int getId() {
        return this.id;
    }

    public Color getColor() {
        int index = this.type.ordinal();
        if (index < typeColors.length) {
            return typeColors[index];
        }
        System.out.println("ERROR : Missing colors.");
        return Color.LIGHTGRAY;
    }

    public static enum WordType {
        DEFAULT,
        INPUT,
        VARIABLE,
        VALUE,
        OPERATOR,
        KEYWORD,
        FUNCTION,
        TABULATION,
        GROUP,
        IMPORT;

    }
}

