/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.properties;

import com.maniacobra.pyzzle.utils.Utils;
import java.io.File;
import java.io.IOException;

public class FilePaths {
    private final String localFilesPath;
    private final String defaultLocalFiles;
    private final String logFile;
    private final String pythonExePath;
    private final String executePy;
    private final String tempPy;
    private final String packFolder;
    private final String settingsPath;
    private final String idsPath;
    private final boolean isLinux = System.getProperty("os.name").toLowerCase().contains("linux");
    private static FilePaths instance = null;

    public static boolean load() {
        instance = new FilePaths();
        return instance.createLocalFolder();
    }

    public static FilePaths getInstance() {
        if (instance == null) {
            instance = new FilePaths();
        }
        return instance;
    }

    public FilePaths() {
        if (this.isLinux) {
            this.localFilesPath = "./";
        } else {
            String localFolder = System.getenv("APPDATA");
            if (localFolder == null) {
                localFolder = System.getProperty("user.home");
            }
            localFolder = localFolder.replace("\\", "/");
            this.localFilesPath = localFolder + "/Pyzzle/";
        }
        this.defaultLocalFiles = "DefaultAppDataFiles";
        this.logFile = this.localFilesPath + "log.txt";
        String osName = System.getProperty("os.name").toLowerCase();
        this.pythonExePath = osName.contains("windows") ? "python/python.exe" : null;
        String pyFilesPath = this.localFilesPath + ".py/";
        this.executePy = pyFilesPath + "execute.py";
        this.tempPy = pyFilesPath + "temp.py";
        this.packFolder = this.localFilesPath + "Packs/";
        this.settingsPath = this.localFilesPath + "settings.json";
        this.idsPath = this.localFilesPath + "info";
    }

    public File getLogFile() {
        return new File(this.logFile);
    }

    public File getTempPyFile() {
        return new File(this.tempPy);
    }

    public File getPackFile() {
        return new File(this.packFolder);
    }

    public File getSettingsFile() {
        return new File(this.settingsPath);
    }

    public File getIdsFile() {
        return new File(this.idsPath);
    }

    public String getExecutePyPath() {
        return this.executePy;
    }

    public String getPythonExePath() {
        return this.pythonExePath;
    }

    private boolean createLocalFolder() {
        if (!this.isLinux) {
            System.out.println("Checking local folder at : " + this.localFilesPath);
            File dir = new File(this.localFilesPath);
            if (!dir.exists()) {
                try {
                    Utils.copyDirectory(new File(this.defaultLocalFiles), new File(this.localFilesPath));
                    System.out.println("Folder created.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }
}

