/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.resources;

import com.maniacobra.pyzzle.Launcher;
import com.maniacobra.pyzzle.models.ExecutionResult;
import com.maniacobra.pyzzle.properties.AppSettings;
import com.maniacobra.pyzzle.properties.AppStyle;
import com.maniacobra.pyzzle.properties.FilePaths;
import com.maniacobra.pyzzle.utils.Popups;
import com.maniacobra.pyzzle.utils.TextUtils;
import com.maniacobra.pyzzle.utils.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Stack;
import javafx.scene.control.Alert;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class CodeRunner {
    private static final int prefixLines = 2;
    private static final CodeRunner instance = new CodeRunner();
    private final Stack<Integer> errorLines = new Stack();
    private String errorType = null;
    private final Random rand = new Random();
    private long processId = 0L;
    private List<String> workingCommand = null;

    public static CodeRunner getInstance() {
        return instance;
    }

    private CodeRunner() {
        System.getenv("APPDATA");
    }

    public Stack<Integer> getErrorLines() {
        return this.errorLines;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public boolean hasError() {
        return !this.errorLines.isEmpty();
    }

    public void reset() {
        this.errorLines.clear();
        this.errorType = null;
    }

    public void prepareCode(String pyCode, List<String> inputs) {
        this.processId = this.rand.nextLong();
        String[] lines = pyCode.split("\n");
        StringBuilder pyBuilder = new StringBuilder();
        pyBuilder.append("def run(");
        for (String input : inputs) {
            pyBuilder.append(input);
            pyBuilder.append("=0, ");
        }
        pyBuilder.append("):\n\tprint(\"##").append(this.processId).append("\")");
        for (String line : lines) {
            pyBuilder.append("\n\t");
            pyBuilder.append(line);
        }
        if (lines.length == 1 && Objects.equals(lines[0], "")) {
            pyBuilder.append("pass");
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(FilePaths.getInstance().getTempPyFile()));
            out.write(pyBuilder.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace(Launcher.output);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecutionResult runCode(TextFlow consoleText, Text dsDeclaration, List<String> dataset, List<String> objective) {
        ExecutionResult result = ExecutionResult.SUCCESS;
        dsDeclaration.setFill(AppStyle.Colors.resultValid);
        consoleText.getChildren().add(dsDeclaration);
        List<String> command = this.getCommand();
        if (command == null) {
            return ExecutionResult.FATAL;
        }
        ArrayList<String> commandExec = new ArrayList<String>(command);
        commandExec.add(FilePaths.getInstance().getExecutePyPath());
        if (dataset != null) {
            commandExec.addAll(dataset);
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(commandExec);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            List<String> lines = in.lines().toList();
            int lineNum = -1;
            int errorState = 0;
            for (String line : lines) {
                block29: {
                    block30: {
                        if (lineNum != -1) break block30;
                        if (!line.startsWith("##")) {
                            if (!line.equals("!!!!!")) {
                                System.out.println("[ERROR] Invalid first line for Python execution : " + line);
                                return ExecutionResult.FATAL;
                            }
                            dsDeclaration.setFill(AppStyle.Colors.resultError);
                            errorState = 1;
                            break block29;
                        } else {
                            try {
                                long number = Long.parseLong(line.substring(2));
                                if (number != this.processId) {
                                    System.out.println("[ERROR] Invalid process identifier for Python execution : " + line);
                                    return ExecutionResult.FATAL;
                                }
                                break block29;
                            }
                            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                                e.printStackTrace(Launcher.output);
                                System.out.println("[ERROR] Invalid first line for Python execution : " + line);
                                return ExecutionResult.FATAL;
                            }
                        }
                    }
                    if (errorState != 0) {
                        if (errorState == 1) {
                            this.errorType = line;
                            ++errorState;
                        } else if (errorState == 2) {
                            try {
                                int lineNb = Integer.parseInt(line) - 2;
                                this.errorLines.add(lineNb);
                                TextUtils.addToTextFlow(consoleText, String.format("[ Erreur de type '%s' \u00e0 la line n\u00b0%d du code. ]\n\n", this.errorType, lineNb), AppStyle.Colors.resultError, false);
                                return ExecutionResult.EXCEPTION;
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace(Launcher.output);
                            }
                            return ExecutionResult.EXCEPTION;
                        }
                    } else if (line.equals("!!!!!")) {
                        dsDeclaration.setFill(AppStyle.Colors.resultError);
                        errorState = 1;
                    } else {
                        Color color = null;
                        if (lineNum >= objective.size()) {
                            color = AppStyle.Colors.resultUnperfect;
                            if (result == ExecutionResult.SUCCESS) {
                                result = ExecutionResult.OVERFLOW;
                                dsDeclaration.setFill(color);
                            }
                        } else if (!objective.get(lineNum).equals(line)) {
                            color = AppStyle.Colors.resultWrong;
                            result = ExecutionResult.WRONG;
                            dsDeclaration.setFill(color);
                        }
                        TextUtils.addToTextFlow(consoleText, line + "\n", color, false);
                    }
                }
                ++lineNum;
            }
            if (lineNum == -1) {
                System.out.println("[ERROR] Empty results for Python execution");
                return ExecutionResult.FATAL;
            }
            if (result != ExecutionResult.OVERFLOW && objective.isEmpty()) {
                TextUtils.addToTextFlow(consoleText, "(vide)\n", AppStyle.Colors.resultEmptyCorrect, false);
            } else {
                while (lineNum < objective.size()) {
                    if (result != ExecutionResult.WRONG) {
                        result = ExecutionResult.INCOMPLETE;
                        dsDeclaration.setFill(AppStyle.Colors.resultWrong);
                    }
                    TextUtils.addToTextFlow(consoleText, "(vide)\n", AppStyle.Colors.resultEmpty, false);
                    ++lineNum;
                }
            }
            TextUtils.addToTextFlow(consoleText, "\n");
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(Launcher.output);
            return ExecutionResult.FATAL;
        }
    }

    public void exceptionPopup() {
        if (this.errorType == null) {
            return;
        }
        String title = "Erreur de type '" + this.errorType + "'";
        String contentIntro = String.format("Erreur de type '%s' \u00e0 la ligne %d", this.errorType, this.errorLines.peek());
        String content = switch (this.errorType) {
            case "SyntaxError" -> "Erreur de syntaxe :\nCette erreur se produit lorsque votre code est mal format\u00e9, v\u00e9rifiez les op\u00e9rateurs, le positionnement des mot-cl\u00e9s et les sauts de ligne. Votre code n'a pas pu s'ex\u00e9cuter.\n(Notez que la ligne identifi\u00e9e de l'erreur n'est pas toujours celle qui cause probl\u00e8me.)";
            case "IndentationError" -> "Erreur d'indentation :\nCette erreur se produit lorsque votre code contient des tabulations positionn\u00e9es ou manquantes, votre code n'a pas pu s'ex\u00e9cuter.";
            case "NameError" -> "Erreur de nom :\nCette erreur se produit lorsque votre code essaie de r\u00e9cup\u00e9rer la valeur d'une variable qui n'existe pas.";
            case "TypeError" -> "Erreur de type :\nCette erreur se produit lorsque votre code essaie d'effectuer une op\u00e9ration sur une variable du mauvais type.";
            default -> "V\u00e9rifiez votre code.";
        };
        Popups.showPopup(title, contentIntro, content, 450, 14, 55);
    }

    public boolean pythonTest() {
        List<String> command = this.getCommand();
        if (command == null) {
            if (AppSettings.getInstance().autoArgs) {
                if (FilePaths.getInstance().getPythonExePath() != null) {
                    Utils.systemAlert(Alert.AlertType.ERROR, "Python 3 introuvable", "La version pr\u00e9-int\u00e9gr\u00e9e de Python de ce logiciel n'est pas accessible, et Python est introuvable dans votre syst\u00e8me.\nVoici ce que vous pouvez tenter de faire :\n- V\u00e9rifier les permissions du logiciel (essayez d'ex\u00e9cuter en tant qu'administrateur).\n- D\u00e9sinstaller et r\u00e9installer Pyzzle.\n- T\u00e9l\u00e9charger et installer la derni\u00e8re version de Python sur votre syst\u00e8me (www.python.org).\n- Si Python est d\u00e9j\u00e0 install\u00e9 sur votre syst\u00e8me, essayez de configurer manuellement les arguments de terminal dans le menu 'Pr\u00e9f\u00e9rences'.\n");
                } else {
                    Utils.systemAlert(Alert.AlertType.ERROR, "Python 3 est introuvable", "Pyzzle install\u00e9 sur un syst\u00e8me autre que Windows a comme pr\u00e9-requis que Python 3 soit install\u00e9.\nVeuillez t\u00e9l\u00e9charger et installer la derni\u00e8re version de Python sur votre syst\u00e8me : www.python.org\nSi Python est d\u00e9j\u00e0 install\u00e9, vous pouvez tenter de configurer manuellement les arguments de terminal dans le menu 'Pr\u00e9f\u00e9rences'.\nVous pouvez \u00e9galement v\u00e9rifier les permissions du logiciel.\n");
                }
            } else {
                Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle ne peut pas fonctionner", "Les arguments de terminal d\u00e9finis manuellement semblent \u00eatre incorrects.\nVeuillez aller dans le menu Pr\u00e9f\u00e9rences et changer ces arguments ou cocher 'Trouver Python automatiquement'.");
            }
            return false;
        }
        this.prepareCode("print(sample + 1)", List.of("sample"));
        ExecutionResult result = this.runCode(new TextFlow(), new Text(), List.of("5"), List.of("6"));
        if (result != ExecutionResult.SUCCESS) {
            Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle ne peut pas fonctionner", "Pyzzle semble avoir des difficult\u00e9s pour fonctionner correctement.\nVeuillez fermer le programme, puis l'ex\u00e9cuter en tant qu'administrateur.\nSi c'est d\u00e9j\u00e0 le cas, alors le logiciel est peut-\u00eatre mal install\u00e9, essayez donc une r\u00e9-installation.");
            return false;
        }
        System.out.println("Script execution is working !");
        return true;
    }

    public List<String> getCommand() {
        if (this.workingCommand != null) {
            return this.workingCommand;
        }
        ArrayList<List<String>> possibleCommands = new ArrayList<List<String>>();
        if (AppSettings.getInstance().autoArgs) {
            if (FilePaths.getInstance().getPythonExePath() != null) {
                possibleCommands.add(List.of(FilePaths.getInstance().getPythonExePath()));
                possibleCommands.add(List.of("cmd", "/c", "py"));
            }
            possibleCommands.add(List.of("python3"));
            possibleCommands.add(List.of("python"));
        } else {
            possibleCommands.add(AppSettings.getInstance().terminalArgs);
        }
        System.out.println("=== FINDING THE CORRECT COMMAND ARGUMENTS ===");
        for (List list : possibleCommands) {
            boolean installed = true;
            ArrayList<String> commandVer = new ArrayList<String>(list);
            commandVer.add("--version");
            StringBuilder builder = new StringBuilder();
            builder.append("Attempt with arguments :");
            for (String arg : list) {
                builder.append(" ");
                builder.append(arg);
            }
            System.out.println(builder);
            try {
                ProcessBuilder pb = new ProcessBuilder(commandVer);
                pb.redirectErrorStream(true);
                Process p = pb.start();
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                List<String> lines = in.lines().toList();
                if (lines.size() != 0) {
                    String ver = lines.get(0);
                    if (!ver.contains("Python 3.")) {
                        installed = false;
                    }
                    System.out.println(ver);
                } else {
                    installed = false;
                }
            }
            catch (Exception e) {
                System.out.println("(Failure)");
                installed = false;
            }
            if (!installed) continue;
            this.workingCommand = list;
            System.out.println(list);
            return list;
        }
        return null;
    }

    public void resetCommand() {
        this.workingCommand = null;
    }
}

