/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.resources;

import com.maniacobra.pyzzle.properties.FilePaths;
import com.maniacobra.pyzzle.resources.PyzzFileManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class IdsRegistry {
    private static IdsRegistry instance = new IdsRegistry();
    private HashMap<String, Integer> registeredIds = new HashMap();

    public static IdsRegistry getInstance() {
        return instance;
    }

    public void save() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Integer> id : this.registeredIds.entrySet()) {
            builder.append(id.getKey()).append(":").append(id.getValue()).append("\n");
        }
        try {
            PyzzFileManager.getInstance().encode(FilePaths.getInstance().getIdsFile(), builder.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            this.registeredIds.clear();
            File f = FilePaths.getInstance().getIdsFile();
            if (f.exists()) {
                String[] lines;
                String data = PyzzFileManager.getInstance().decode(f);
                for (String line : lines = data.split("\n")) {
                    String[] splitted = line.split(":");
                    if (splitted.length <= 1) continue;
                    String key = splitted[0];
                    Integer val = Integer.parseInt(splitted[1]);
                    this.registeredIds.put(key, val);
                }
            }
            this.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void incrementId(String id) {
        if (!this.registeredIds.containsKey(id)) {
            this.registeredIds.put(id, 1);
        } else {
            this.registeredIds.put(id, this.registeredIds.get(id) + 1);
        }
        this.save();
    }

    public int getCount(String id) {
        if (this.registeredIds.containsKey(id)) {
            return this.registeredIds.get(id);
        }
        return 0;
    }
}

