/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.views.blockeditor;

import com.maniacobra.pyzzle.models.Word;
import com.maniacobra.pyzzle.properties.AppStyle;
import com.maniacobra.pyzzle.utils.TextUtils;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class WordBlock {
    private static final int fontSize = 14;
    public static final int blockHeight = 21;
    private final Word word;
    private final Color color;
    private final int x;
    private final int y;
    private final int width;
    private final boolean showUsages;

    public WordBlock(Word word, int x, int y, GraphicsContext gc, boolean showUsages) {
        this.word = word;
        this.x = x;
        this.y = y;
        this.color = word.getColor();
        this.showUsages = showUsages;
        gc.setFont(new Font("Arial", 14.0));
        this.width = TextUtils.textWidth(gc.getFont(), word.getText());
    }

    public void draw(GraphicsContext gc) {
        gc.setFill(this.word.getUsages() == 0 ? AppStyle.Colors.mix(this.color, AppStyle.Colors.canvasBackground, 0.35) : this.color);
        gc.fillRect(this.x, this.y, this.width + 14, 21.0);
        if (this.showUsages) {
            gc.setFill(this.word.getUsages() == 0 ? AppStyle.Colors.mix(Color.BLACK, AppStyle.Colors.canvasBackground, 0.35) : Color.BLACK);
            gc.fillRect(this.x + this.width + 14, (double)this.y + 2.1, 12.6, 16.8);
            gc.setFill(Color.WHITE);
            String text = this.word.getUsages() == -1 ? "\u221e" : String.valueOf(this.word.getUsages());
            gc.fillText(text, (double)(this.x + this.width) + 15.400000000000002, (double)this.y + 15.75);
        }
        if (this.word.getType() != Word.WordType.TABULATION) {
            Color tempColor = this.word.getUsages() == 0 ? AppStyle.Colors.mix(AppStyle.Colors.blockText, AppStyle.Colors.canvasBackground, 0.35) : AppStyle.Colors.blockText;
            gc.setFill(tempColor);
            gc.setStroke(tempColor);
            gc.setLineWidth(2.0);
            gc.strokeRect(this.x, this.y, this.width + 14, 21.0);
            gc.fillText(this.word.getText(), (float)this.x + 7.0f, this.y + 14);
        }
    }

    public boolean collide(int x, int y) {
        return this.word.getUsages() != 0 && x > this.x && y > this.y && x < this.x + this.getWidth() && y < this.y + 21;
    }

    public int getWidth() {
        return this.width + (int)(14.0 * (this.showUsages ? 1.8 : 1.0));
    }

    public int getWidthNoUsage() {
        return this.width + 14;
    }

    public Word getWord() {
        return this.word;
    }

    public int getX() {
        return this.x;
    }
}

