/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.models;

import com.maniacobra.pyzzle.Launcher;
import com.maniacobra.pyzzle.controllers.ExerciseController;
import com.maniacobra.pyzzle.controllers.IntroController;
import com.maniacobra.pyzzle.models.ExerciseConfig;
import com.maniacobra.pyzzle.properties.AppProperties;
import com.maniacobra.pyzzle.properties.AppSettings;
import com.maniacobra.pyzzle.resources.IdsRegistry;
import com.maniacobra.pyzzle.resources.PyzzFileManager;
import com.maniacobra.pyzzle.utils.Popups;
import com.maniacobra.pyzzle.utils.Utils;
import com.maniacobra.pyzzle.views.PyzzleMain;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Alert;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ExerciseManager {
    private float maxScore;
    private int packLength;
    private String packName;
    private String packFileName;
    private String authorName;
    private String userName;
    private int strictMode;
    private String uuidStr;
    private boolean isIntro;
    private JSONObject loadedData = null;
    private final ArrayList<JSONObject> exercises = new ArrayList();
    private ExerciseController currentController = null;
    private final HashMap<Integer, JSONObject> savedCompletion = new HashMap();
    private File saveFile = null;
    private BorderPane mainPane = null;
    private AnchorPane currentPane = null;
    private BorderPane introPane = null;
    private final boolean paneSaving = false;
    private final HashMap<Integer, ExerciseController> loadedControllers = new HashMap();
    private final HashMap<Integer, AnchorPane> loadedPanes = new HashMap();

    public ExerciseManager() {
        this.setDefaultInfos();
    }

    private void setDefaultInfos() {
        this.maxScore = 0.0f;
        this.packLength = 0;
        this.packName = "Sans nom";
        this.packFileName = "Sans_nom";
        this.authorName = null;
        this.userName = null;
        this.strictMode = 0;
        this.uuidStr = "-";
        this.isIntro = false;
    }

    public boolean openFile(File file, BorderPane mainPane) {
        this.mainPane = mainPane;
        System.out.println("Opening : " + file.getAbsolutePath());
        try {
            boolean hasCompletion;
            String fileType;
            JSONObject jsonData;
            try {
                String data = file.getName().endsWith(".json") ? PyzzFileManager.getInstance().readNormal(file) : PyzzFileManager.getInstance().decode(file);
                JSONParser parser = new JSONParser();
                jsonData = (JSONObject)parser.parse(data);
            }
            catch (IOException e) {
                e.printStackTrace(Launcher.output);
                this.displayErrorMessage(OpeningResult.OPENING_ERROR);
                return false;
            }
            try {
                String version = jsonData.get("pyzzle_version").toString();
                if (!version.equals("Prototype 1.0")) {
                    Utils.systemAlert(Alert.AlertType.WARNING, "Attention : Versions potentiellement incompatibles", String.format("La version du fichier ouvert (%s) est potentiellement incompatible avec la version install\u00e9e de Pyzzle (%s). Il est probable que des erreurs surviennent.", version, "Prototype 1.0"));
                }
                fileType = jsonData.get("file_type").toString();
                hasCompletion = fileType.equals("opened_pack");
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                this.displayErrorMessage(OpeningResult.DATA_ERROR);
                return false;
            }
            if (fileType.equals("pack") || hasCompletion) {
                OpeningResult result = this.loadPack(jsonData, hasCompletion);
                if (result != OpeningResult.OK) {
                    this.displayErrorMessage(result);
                    return false;
                }
                this.packFileName = file.getName();
                AppSettings.getInstance().lastOpenedPath = file.getAbsolutePath();
                if (hasCompletion) {
                    this.saveFile = file;
                }
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace(Launcher.output);
            this.displayErrorMessage(OpeningResult.PARSING_ERROR);
        }
        catch (Exception e) {
            e.printStackTrace(Launcher.output);
            this.displayErrorMessage(OpeningResult.UNKNOWN_ERROR);
        }
        return false;
    }

    public void goToExercise(BorderPane mainPane, int number) {
        float currentScore;
        this.mainPane = mainPane;
        if (number < 0 || number >= this.exercises.size()) {
            return;
        }
        this.savedCompletion.put(this.currentController.getModel().getExerciseNumber(), this.currentController.getModel().getJson());
        float f = currentScore = this.currentController == null ? 0.0f : this.currentController.getModel().getTotalScore();
        if (this.loadedPanes.containsKey(number) && this.loadedControllers.containsKey(number)) {
            mainPane.setCenter(this.loadedPanes.get(number));
            this.currentController = this.loadedControllers.get(number);
            this.currentController.updateScore(currentScore);
            return;
        }
        JSONObject exerciseCompletion = this.savedCompletion.get(number);
        ExerciseConfig config = new ExerciseConfig(this.exercises.get(number), number, this.exercises.size(), currentScore, this.maxScore, exerciseCompletion);
        OpeningResult result = this.loadExercise(config, true);
        if (result != OpeningResult.OK) {
            this.displayErrorMessage(result);
        }
    }

    public boolean saveData(File file) {
        this.saveFile = file;
        return this.saveData();
    }

    public boolean saveData() {
        if (this.currentController != null) {
            this.updateName();
        }
        if (this.loadedData == null || this.saveFile == null) {
            return false;
        }
        assert (this.currentController != null);
        this.savedCompletion.put(this.currentController.getModel().getExerciseNumber(), this.currentController.getModel().getJson());
        JSONObject data = this.loadedData;
        data.put("file_type", "opened_pack");
        JSONObject completion = new JSONObject();
        completion.put("total_score", Float.valueOf(this.currentController.getModel().getTotalScore()));
        completion.put("last_panel", this.currentController.getModel().getExerciseNumber());
        completion.put("user_name", this.userName);
        completion.put("attempt", IdsRegistry.getInstance().getCount(this.uuidStr));
        JSONArray completedExercises = new JSONArray();
        for (int i = 0; i < this.packLength; ++i) {
            JSONObject obj = new JSONObject();
            obj.put("empty", true);
            completedExercises.add(obj);
        }
        for (Map.Entry<Integer, JSONObject> entry : this.savedCompletion.entrySet()) {
            completedExercises.set(entry.getKey(), entry.getValue());
        }
        completion.put("exercises", completedExercises);
        data.put("completion", completion);
        try {
            PyzzFileManager.getInstance().encode(this.saveFile, data.toJSONString());
            AppSettings.getInstance().lastOpenedPath = this.saveFile.getAbsolutePath();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.displayErrorMessage(OpeningResult.SAVING_ERROR);
            return false;
        }
    }

    public void startFirstExercise() {
        this.saveData();
        this.mainPane.setCenter(this.currentPane);
        this.introPane = null;
        System.gc();
    }

    public String getSaveFileSuggestion() {
        String fileName;
        String[] splitted = this.packFileName.split("\\.");
        String string = fileName = splitted.length > 0 ? splitted[0] : this.packFileName;
        if (this.userName == null) {
            return fileName + ".spyzl";
        }
        return fileName + " " + Utils.convertToFileName(this.userName) + ".spyzl";
    }

    public boolean hasSaveFile() {
        return this.saveFile != null;
    }

    public Pane getCurrentPane() {
        return this.introPane != null ? this.introPane : this.currentPane;
    }

    public void setUserName(String userName) {
        this.userName = userName.length() == 0 ? null : userName;
    }

    public void displayHelpIfIntro() {
        if (!this.isIntro) {
            return;
        }
        Popups.showPopup("Aide Pyzzle", "Bienvenue sur Pyzzle !", "\nUtilisez les blocs disponibles pour construire votre programme afin que le r\u00e9sultat de son ex\u00e9cution soit identique \u00e0 la zone \"Objectifs\".\n\nUtilisez le clic gauche pour glisser-d\u00e9poser les blocs, ou clic droit pour directement les envoyer d'une zone \u00e0 une autre.\nShift + clic droit sur un bloc disponible pour rapidement faire un retour \u00e0 la ligne.\n", 550, 14, 55);
    }

    public boolean isExamMode() {
        return this.strictMode >= 2;
    }

    public boolean hasUserName() {
        return this.userName != null;
    }

    public boolean isLoaded() {
        return this.currentPane != null;
    }

    private OpeningResult loadPack(JSONObject jsonData, boolean hasCompletion) throws IOException {
        this.resetPack();
        this.isIntro = false;
        int starting = 0;
        float totalScore = 0.0f;
        JSONObject exerciseCompletion = null;
        try {
            this.loadedData = jsonData;
            this.packName = jsonData.get("pack_name").toString();
            this.authorName = jsonData.get("author").toString();
            this.strictMode = Utils.getInt(jsonData, "strict_mode");
            this.uuidStr = jsonData.get("uuid").toString();
            UUID uuid = UUID.fromString(this.uuidStr);
            if (uuid.equals(AppProperties.introUUID)) {
                this.isIntro = true;
            }
            IdsRegistry.getInstance().incrementId(this.uuidStr);
            this.maxScore = 0.0f;
            for (Object obj : (JSONArray)jsonData.get("exercises")) {
                JSONObject jsonExo = (JSONObject)obj;
                this.exercises.add(jsonExo);
                this.maxScore += Utils.getFloat(jsonExo, "coef");
                ++this.packLength;
            }
            if (hasCompletion) {
                JSONObject completion = (JSONObject)jsonData.get("completion");
                starting = Utils.getInt(completion, "last_panel");
                totalScore = Utils.getFloat(completion, "total_score");
                this.userName = completion.get("user_name").toString();
                int i = 0;
                for (Object completed : (JSONArray)completion.get("exercises")) {
                    this.savedCompletion.put(i, (JSONObject)completed);
                    ++i;
                }
                exerciseCompletion = (JSONObject)((JSONArray)completion.get("exercises")).get(starting);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace(Launcher.output);
            return OpeningResult.DATA_ERROR;
        }
        ExerciseConfig firstExercise = new ExerciseConfig(this.exercises.get(starting), starting, this.exercises.size(), totalScore, this.maxScore, exerciseCompletion);
        this.loadExercise(firstExercise, hasCompletion);
        if (this.strictMode >= 2) {
            AppSettings.getInstance().autoSave = true;
            AppSettings.getInstance().updateName = false;
        }
        if (!hasCompletion) {
            this.loadIntro(this.mainPane);
        } else {
            StringBuilder builder = new StringBuilder();
            if (this.packName != null && !this.packName.isEmpty()) {
                builder.append("Titre du pack d'exercices :\n").append(this.packName).append("\n\n");
            }
            if (this.userName != null && !this.userName.isEmpty()) {
                builder.append("Nom de l'utilisateur : ").append(this.userName).append("\n\n");
            }
            if (this.authorName != null && !this.authorName.isEmpty()) {
                builder.append("Nom du cr\u00e9ateur du pack : ").append(this.authorName);
            }
            if (!builder.isEmpty()) {
                Utils.systemAlert(Alert.AlertType.INFORMATION, "Pyzzle : Informations sur le pack", builder.toString());
            }
        }
        return OpeningResult.OK;
    }

    private OpeningResult loadExercise(ExerciseConfig config, boolean enableUI) {
        try {
            AnchorPane pane;
            FXMLLoader fxmlLoader = new FXMLLoader(PyzzleMain.class.getResource("exercise-view.fxml"));
            if (this.currentController != null) {
                this.currentController.clearMemory();
            }
            if (enableUI) {
                this.mainPane.setCenter(null);
            }
            System.gc();
            this.currentPane = pane = (AnchorPane)fxmlLoader.load();
            ExerciseController controller = (ExerciseController)fxmlLoader.getController();
            if (!controller.loadConfig(config)) {
                return OpeningResult.DATA_ERROR;
            }
            this.currentController = controller;
            this.currentController.setManger(this);
            if (enableUI) {
                this.mainPane.setCenter(pane);
                this.updateName();
            }
            return OpeningResult.OK;
        }
        catch (Exception e) {
            e.printStackTrace(Launcher.output);
            return OpeningResult.UNKNOWN_ERROR;
        }
    }

    private void loadIntro(BorderPane borderPane) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(PyzzleMain.class.getResource("intro-view.fxml"));
        this.introPane = (BorderPane)fxmlLoader.load();
        IntroController controller = (IntroController)fxmlLoader.getController();
        controller.init(this, this.packName, this.authorName, this.strictMode > 0, this.strictMode >= 2, IdsRegistry.getInstance().getCount(this.uuidStr));
        borderPane.setCenter(this.introPane);
    }

    private void updateName() {
        AppSettings settings = AppSettings.getInstance();
        String prefix = "Nom inscrit : ";
        if (settings.updateName && this.strictMode < 2 && !settings.userName.equals(this.userName)) {
            this.userName = settings.userName;
            this.currentController.updateUserName(prefix + this.userName);
            Utils.systemAlert(Alert.AlertType.INFORMATION, "Nom chang\u00e9", "Le NOM / Pr\u00e9nom inscrit dans ce Pack d'exercices vient d'\u00eatre automatiquement mis \u00e0 jour par les param\u00e8tres :\n" + this.userName);
        } else {
            this.currentController.updateUserName(prefix + this.userName);
        }
    }

    private void displayErrorMessage(OpeningResult oResult) {
        switch (oResult.ordinal()) {
            case 1: {
                Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle : Erreur", "Une erreur inconnue, interne au logiciel, s'est produite lors du chagement de l'exercice.");
                break;
            }
            case 2: {
                Utils.systemAlert(Alert.AlertType.ERROR, "Pyzze : Erreur lors de l'ouverture du fichier", "Pyzzle n'est pas parvenu \u00e0 ouvrir ce fichier, v\u00e9rifiez les permissions du programme et si le fichier est accessible.");
                break;
            }
            case 3: {
                Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle : Erreur lors du chargement de l'exercice", "Le fichier semble \u00eatre corrompu ou de format invalide. Impossible d'ouvrir");
                break;
            }
            case 4: {
                Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle : Erreur lors du chargement de l'exercice", "Le fichier semble avoir des informations manquantes, mal formatt\u00e9es ou invalides. Impossible d'ouvrir.");
                break;
            }
            case 5: {
                Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle : Impossible de sauvegarder", "Une erreur inconnue s'est produite lors de la sauvegarde de l'exercice, v\u00e9rifiez les permissions.");
            }
        }
    }

    private void resetPack() {
        this.exercises.clear();
        if (this.currentController != null) {
            this.currentController.clearMemory();
            this.currentController = null;
        }
        this.savedCompletion.clear();
        this.saveFile = null;
        this.currentPane = null;
        this.introPane = null;
        this.mainPane.setCenter(null);
        for (ExerciseController controller : this.loadedControllers.values()) {
            controller.clearMemory();
        }
        this.loadedControllers.clear();
        this.loadedPanes.clear();
        System.gc();
        this.setDefaultInfos();
    }

    private static enum OpeningResult {
        OK,
        UNKNOWN_ERROR,
        OPENING_ERROR,
        PARSING_ERROR,
        DATA_ERROR,
        SAVING_ERROR;

    }
}

