/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.models;

import com.maniacobra.pyzzle.Launcher;
import com.maniacobra.pyzzle.controllers.ExerciseNodes;
import com.maniacobra.pyzzle.models.ExecutionResult;
import com.maniacobra.pyzzle.models.ExerciseConfig;
import com.maniacobra.pyzzle.models.Word;
import com.maniacobra.pyzzle.properties.AppStyle;
import com.maniacobra.pyzzle.resources.CodeRunner;
import com.maniacobra.pyzzle.utils.TextUtils;
import com.maniacobra.pyzzle.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.scene.control.Alert;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ExerciseModel {
    private boolean loaded;
    private boolean simple;
    private float coef;
    private int attempts;
    private float initialTotalScore;
    private float totalScore;
    private float score;
    private float maxScore;
    private String name;
    private int exerciseNumber;
    private int totalExercises;
    private boolean locked;
    private boolean solutionDisplayed;
    private boolean win;
    private final ArrayList<String> inputs = new ArrayList();
    private final ArrayList<List<String>> datasets = new ArrayList();
    private final ArrayList<List<String>> objectives = new ArrayList();
    private final ArrayList<ArrayList<Word>> words = new ArrayList();
    private ArrayList<ArrayList<Integer>> idsPlaced = new ArrayList();
    private final ArrayList<ArrayList<Integer>> idsSolution = new ArrayList();
    private JSONArray resultTextJson = new JSONArray();

    public ExerciseModel() {
        this.resetAll();
    }

    public boolean loadExercise(ExerciseConfig config, ExerciseNodes nodes) {
        this.resetAll();
        if (config.data() != null && !this.loadJsonData(config.data())) {
            return false;
        }
        this.exerciseNumber = config.exerciseNumber();
        this.totalExercises = config.totalExercises();
        if (config.exerciseNumber() <= 0) {
            nodes.previousButton().setDisable(true);
        }
        nodes.nextButton().setDisable(true);
        nodes.numberText().setText(String.format("Exercice %d / %d", config.exerciseNumber() + 1, config.totalExercises()));
        nodes.nameText().setText(this.name);
        nodes.completionText().setText("Non termin\u00e9");
        nodes.objectivesText().getChildren().clear();
        int i = 0;
        for (List<String> objective : this.objectives) {
            nodes.objectivesText().getChildren().add(this.getDsDeclaration(i));
            if (objective.isEmpty()) {
                TextUtils.addToTextFlow(nodes.objectivesText(), "(vide)\n");
            } else {
                for (String string : objective) {
                    TextUtils.addToTextFlow(nodes.objectivesText(), string + "\n");
                }
            }
            TextUtils.addToTextFlow(nodes.objectivesText(), "\n");
            ++i;
        }
        if (config.completion() != null && config.completion().get("empty") == null) {
            JSONObject completion = config.completion();
            this.attempts = Utils.getInt(completion, "attempts");
            this.win = (Boolean)completion.get("win");
            this.score = Utils.getFloat(completion, "score");
            this.idsPlaced.clear();
            for (Object lineObj : (JSONArray)config.completion().get("placed_words")) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (Object id : (JSONArray)lineObj) {
                    if (id instanceof Integer) {
                        arrayList.add((Integer)id);
                        continue;
                    }
                    if (!(id instanceof Long)) continue;
                    arrayList.add(((Long)id).intValue());
                }
                this.idsPlaced.add(arrayList);
            }
            this.resultTextJson = (JSONArray)completion.get("result_text");
        }
        this.initialTotalScore = config.totalScore();
        this.maxScore = config.maxScore();
        this.totalScore = this.initialTotalScore;
        this.updateScore(nodes);
        return true;
    }

    public void setIdsPlaced(ArrayList<ArrayList<Integer>> ids) {
        if (!this.solutionDisplayed) {
            this.idsPlaced = ids;
        }
    }

    public ArrayList<ArrayList<Word>> getWords() {
        ArrayList<ArrayList<Word>> wordsCopy = new ArrayList<ArrayList<Word>>();
        for (List list : this.words) {
            ArrayList<Word> newLine = new ArrayList<Word>();
            for (Word word : list) {
                newLine.add(word.getCopy(false));
            }
            wordsCopy.add(newLine);
        }
        return wordsCopy;
    }

    public ArrayList<ArrayList<Word>> getSolutionOrPlaced() {
        ArrayList<ArrayList<Word>> wordsCopy = new ArrayList<ArrayList<Word>>();
        for (List list : this.solutionDisplayed ? this.idsSolution : this.idsPlaced) {
            ArrayList<Word> newLine = new ArrayList<Word>();
            for (Integer id : list) {
                for (List list2 : this.words) {
                    for (Word word : list2) {
                        if (word.getId() != id.intValue()) continue;
                        newLine.add(word.getCopy(true));
                    }
                }
            }
            wordsCopy.add(newLine);
        }
        return wordsCopy;
    }

    public void switchSolution() {
        this.solutionDisplayed = !this.solutionDisplayed;
    }

    public int getExerciseNumber() {
        return this.exerciseNumber;
    }

    public float getTotalScore() {
        return this.totalScore;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setTotalScore(float totalScore, ExerciseNodes nodes) {
        this.totalScore = totalScore;
        this.updateScore(nodes);
    }

    public boolean isSolutionDisplayed() {
        return this.solutionDisplayed;
    }

    public boolean proceedExecution(ExerciseNodes nodes) {
        String message;
        Color color;
        boolean worse;
        if (!this.loaded) {
            return false;
        }
        CodeRunner.getInstance().reset();
        CodeRunner.getInstance().prepareCode(nodes.codeText().toString(), this.inputs);
        nodes.consoleText().getChildren().clear();
        CodeRunner.getInstance().prepareCode(nodes.codeText().getText(), this.inputs);
        float tempScore = 0.0f;
        HashSet<String> errors = new HashSet<String>();
        int nbSets = this.simple ? 1 : this.datasets.size();
        block6: for (int i = 0; i < nbSets; ++i) {
            ExecutionResult result = CodeRunner.getInstance().runCode(nodes.consoleText(), this.getDsDeclaration(i), this.simple ? null : this.datasets.get(i), this.objectives.get(i));
            switch (result) {
                case SUCCESS: {
                    tempScore += 1.0f;
                    continue block6;
                }
                case OVERFLOW: {
                    tempScore = (float)((double)tempScore + 0.5);
                    continue block6;
                }
                case EXCEPTION: {
                    CodeRunner instance = CodeRunner.getInstance();
                    if (!instance.hasError() || errors.contains(instance.getErrorType())) continue block6;
                    errors.add(instance.getErrorType());
                    instance.exceptionPopup();
                    continue block6;
                }
                case FATAL: {
                    nodes.consoleText().getChildren().clear();
                    if (CodeRunner.getInstance().pythonTest()) {
                        Utils.systemAlert(Alert.AlertType.ERROR, "Erreur fatale de Pyzzle", "Une erreur inconnue du logiciel est survenue, cette erreur n'est PAS caus\u00e9e par votre code. V\u00e9rifiez l'installation du logiciel.");
                    }
                    return false;
                }
            }
        }
        if (this.attempts > 0) {
            --this.attempts;
        }
        boolean bl = worse = this.score > (tempScore /= (float)nbSets);
        if (!worse) {
            this.score = tempScore * this.coef;
        }
        this.win = tempScore == 1.0f;
        this.totalScore = this.initialTotalScore + this.score;
        if (tempScore == 0.0f) {
            color = AppStyle.Colors.resultWrong;
            message = "\u00c9CHEC\n\n";
        } else if (this.win) {
            color = AppStyle.Colors.resultValid;
            message = "R\u00c9USSITE !\n\n";
        } else {
            color = AppStyle.Colors.resultUnperfect;
            message = "IMPARFAITS\n\n";
        }
        TextUtils.addToTextFlow(nodes.consoleText(), "\nR\u00c9SULTAT DES TESTS : " + message, color, true);
        TextUtils.addToTextFlow(nodes.consoleText(), String.format("Points gagn\u00e9s : %s sur %s\n\n", Utils.nbToStr(tempScore * this.coef), Utils.nbToStr(this.coef)), color, false);
        boolean result = false;
        if (!this.win) {
            if (worse) {
                TextUtils.addToTextFlow(nodes.consoleText(), "Ce score est inf\u00e9rieur au pr\u00e9c\u00e9dent essai et n'est donc pas pris en compte.\n");
            }
            if (this.attempts > 0) {
                TextUtils.addToTextFlow(nodes.consoleText(), String.format("Vous avez %d %s pour tenter de faire mieux.\n", this.attempts, this.attempts == 1 ? "essai restant" : "essais restants"), AppStyle.Colors.objectives, true);
            }
            TextUtils.addToTextFlow(nodes.consoleText(), "Info : un seul r\u00e9sultat vide ou diff\u00e9rent de celui souhait\u00e9\nm\u00e8ne \u00e0 la perte de tous les points d'un test.", AppStyle.Colors.info, true);
        } else {
            result = true;
        }
        if (this.attempts == 0) {
            result = true;
        }
        this.updateScore(nodes);
        this.textFlowToJson(nodes.consoleText());
        return result;
    }

    public JSONObject getJson() {
        JSONObject data = new JSONObject();
        data.put("score", Float.valueOf(this.score));
        data.put("attempts", this.attempts);
        data.put("win", this.win);
        data.put("result_text", this.resultTextJson);
        JSONArray idsJson = new JSONArray();
        for (ArrayList<Integer> line : this.idsPlaced) {
            JSONArray jsonLine = new JSONArray();
            jsonLine.addAll(line);
            idsJson.add(jsonLine);
        }
        data.put("placed_words", idsJson);
        return data;
    }

    public ArrayList<Integer> getIdsPlaced() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (ArrayList<Integer> line : this.idsPlaced) {
            ids.addAll(line);
        }
        return ids;
    }

    private Text getDsDeclaration(int dsNb) {
        StringBuilder strBuilder = new StringBuilder();
        if (this.simple) {
            strBuilder.append("R\u00c9SULTAT\n\n");
        } else {
            strBuilder.append("TEST N\u00b0");
            strBuilder.append(dsNb + 1);
            strBuilder.append(" AVEC : ");
            int i = 0;
            for (String input : this.inputs) {
                strBuilder.append(input);
                strBuilder.append(" = ");
                strBuilder.append(this.datasets.get(dsNb).get(i));
                if (i < this.inputs.size() - 1) {
                    strBuilder.append(", ");
                }
                ++i;
            }
            strBuilder.append("\n\n");
        }
        Text text = new Text(strBuilder.toString());
        text.setTextAlignment(TextAlignment.CENTER);
        text.setFont(Font.font("Arial", FontWeight.BOLD, 12.0));
        return text;
    }

    private void textFlowToJson(TextFlow textFlow) {
        this.resultTextJson.clear();
        textFlow.getChildren().forEach(t -> {
            JSONObject textJson = new JSONObject();
            Text text = (Text)t;
            textJson.put("text", text.getText());
            textJson.put("color", text.getFill().toString());
            textJson.put("bold", text.getFont().getStyle().equals("Bold"));
            this.resultTextJson.add(textJson);
        });
    }

    private void updateScore(ExerciseNodes nodes) {
        if (!this.loaded) {
            return;
        }
        nodes.scoreText().setText(String.format("Score total de tous les exercices :\n%s / %s points", Utils.nbToStr(this.totalScore), Utils.nbToStr(this.maxScore)));
        if (this.attempts > 0) {
            nodes.attemptsText().setText("Essais restants : " + this.attempts);
        } else if (this.attempts == 0) {
            nodes.attemptsText().setText("Aucun essai restant");
        } else {
            nodes.attemptsText().setText("Essais illimit\u00e9s");
        }
        if (this.win) {
            nodes.completionText().setText("R\u00e9ussi \u00e0 100% !");
            nodes.completionText().setFill(AppStyle.Colors.fullCompletion);
            this.lock(nodes);
        } else if (this.attempts == 0) {
            nodes.completionText().setText(String.format("Termin\u00e9 avec %s sur %s points", Utils.nbToStr(this.score), Utils.nbToStr(this.coef)));
            this.lock(nodes);
        }
    }

    private boolean loadJsonData(JSONObject data) {
        try {
            this.coef = Utils.getFloat(data, "coef");
            this.attempts = Utils.getInt(data, "attempts");
            this.name = data.get("name").toString();
            if (data.get("inputs") != null) {
                for (Object elem : (JSONArray)data.get("inputs")) {
                    this.inputs.add((String)elem);
                }
            }
            if (data.get("datasets") != null) {
                for (Object elem : (JSONArray)data.get("datasets")) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    this.datasets.add(arrayList);
                    for (Object elem2 : (JSONArray)elem) {
                        arrayList.add(String.valueOf(elem2));
                    }
                }
            }
            for (Object elem : (JSONArray)data.get("objectives")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                this.objectives.add(arrayList);
                for (Object elem2 : (JSONArray)elem) {
                    arrayList.add(elem2.toString());
                }
            }
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (Object e : (JSONArray)data.get("words")) {
                ArrayList<Word> wordList = new ArrayList<Word>();
                this.words.add(wordList);
                for (Object elem2 : (JSONArray)e) {
                    JSONObject jsonW = (JSONObject)elem2;
                    int id = Utils.getInt(jsonW, "id");
                    assert (!ids.contains(id));
                    ids.add(id);
                    Word word = new Word(Word.WordType.valueOf(jsonW.get("type").toString()), jsonW.get("text").toString(), Utils.getInt(jsonW, "usages"), id);
                    wordList.add(word);
                }
            }
            for (Object e : (JSONArray)data.get("solution")) {
                ArrayList<Integer> line = new ArrayList<Integer>();
                this.idsSolution.add(line);
                for (Object elem2 : (JSONArray)e) {
                    line.add(((Long)elem2).intValue());
                }
            }
            if (this.inputs.size() == 0) {
                assert (this.objectives.size() == 1 && this.datasets.size() == 0);
                this.simple = true;
            } else {
                this.simple = false;
                assert (this.datasets.size() == this.objectives.size());
                for (List list : this.datasets) {
                    assert (list.size() == this.inputs.size());
                }
            }
            assert (this.coef >= 0.0f);
            this.loaded = true;
            return true;
        }
        catch (AssertionError | Exception e) {
            Utils.systemAlert(Alert.AlertType.ERROR, "Erreur lors du chargement de l'exercice", "L'exercice semble avoir des donn\u00e9es manquantes ou mal format\u00e9es, et n'a pas pu \u00eatre charg\u00e9.");
            ((Throwable)e).printStackTrace(Launcher.output);
            return false;
        }
    }

    private void lock(ExerciseNodes nodes) {
        nodes.executionButton().setDisable(true);
        nodes.resetButton().setDisable(true);
        nodes.solutionButton().setDisable(false);
        if (this.exerciseNumber < this.totalExercises - 1) {
            nodes.nextButton().setDisable(false);
        }
        this.locked = true;
    }

    private void resetAll() {
        this.loaded = false;
        this.simple = false;
        this.coef = -1.0f;
        this.attempts = 0;
        this.initialTotalScore = 0.0f;
        this.totalScore = 0.0f;
        this.score = 0.0f;
        this.maxScore = 0.0f;
        this.name = "Exercice sans nom";
        this.exerciseNumber = 0;
        this.totalExercises = 1;
        this.inputs.clear();
        this.datasets.clear();
        this.objectives.clear();
        this.words.clear();
        this.idsPlaced.clear();
        this.idsSolution.clear();
        this.locked = false;
        this.solutionDisplayed = false;
    }
}

