/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.properties;

import com.maniacobra.pyzzle.properties.FilePaths;
import com.maniacobra.pyzzle.utils.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javafx.scene.control.Alert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AppSettings {
    private static final AppSettings instance = new AppSettings();
    public String userName = "";
    public boolean updateName = false;
    public boolean autoSave = true;
    public boolean dragAndDrop = true;
    public boolean autoArgs = true;
    public ArrayList<String> terminalArgs = new ArrayList();
    public String lastOpenedPath = null;

    public static AppSettings getInstance() {
        return instance;
    }

    private AppSettings() {
    }

    public void save() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userName", this.userName);
        jsonObject.put("updateName", this.updateName);
        jsonObject.put("autoSave", this.autoSave);
        jsonObject.put("dragAndDrop", this.dragAndDrop);
        jsonObject.put("autoArgs", this.autoArgs);
        jsonObject.put("lastOpenedPath", this.lastOpenedPath);
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(this.terminalArgs);
        jsonObject.put("terminalArgs", jsonArray);
        try (FileWriter file = new FileWriter(FilePaths.getInstance().getSettingsFile());){
            file.write(jsonObject.toJSONString());
        }
        catch (IOException e) {
            e.printStackTrace();
            Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle : Impossible de sauvegarder les param\u00e8tres", "Une erreur inconnue s'est produite lors de la sauvegarde des param\u00e8tres, v\u00e9rifiez les permissions.");
        }
    }

    private boolean getBool(JSONObject jsonObject, String key, boolean defaultVal) {
        if (!jsonObject.containsKey(key)) {
            return defaultVal;
        }
        if (jsonObject.get(key) instanceof Boolean) {
            return (Boolean)jsonObject.get(key);
        }
        return defaultVal;
    }

    private String getString(JSONObject jsonObject, String key, String defaultVal) {
        if (!jsonObject.containsKey(key)) {
            return defaultVal;
        }
        if (jsonObject.get(key) instanceof String) {
            return (String)jsonObject.get(key);
        }
        return defaultVal;
    }

    public void load() {
        File file = FilePaths.getInstance().getSettingsFile();
        if (!file.exists()) {
            System.out.println("Settings files doesn't exist, creating...");
            this.save();
            return;
        }
        JSONParser parser = new JSONParser();
        try (FileReader reader = new FileReader(file);){
            Object obj = parser.parse(reader);
            JSONObject jsonObject = (JSONObject)obj;
            this.userName = this.getString(jsonObject, "userName", this.userName);
            this.updateName = this.getBool(jsonObject, "updateName", this.updateName);
            this.autoSave = this.getBool(jsonObject, "autoSave", this.autoSave);
            this.dragAndDrop = this.getBool(jsonObject, "dragAndDrop", this.dragAndDrop);
            this.autoArgs = this.getBool(jsonObject, "autoArgs", this.autoArgs);
            this.lastOpenedPath = this.getString(jsonObject, "lastOpenedPath", this.lastOpenedPath);
            System.out.println(this.lastOpenedPath);
            this.terminalArgs.clear();
            JSONArray jsonArray = (JSONArray)jsonObject.get("terminalArgs");
            for (Object item : jsonArray) {
                this.terminalArgs.add((String)item);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle : Impossible de charger les param\u00e8tres", "Une erreur inconnue s'est produite lors du chargement des param\u00e8tres, v\u00e9rifiez les permissions du logiciel.");
        }
        catch (ParseException e) {
            e.printStackTrace();
            Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle : Impossible de charger les param\u00e8tres", "Une erreur inconnue s'est produite lors du chargement des param\u00e8tres, le fichier est peut-\u00eatre corrompu.");
        }
        this.save();
    }
}

