/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.resources;

import com.maniacobra.pyzzle.resources.AnalysisResult;
import com.maniacobra.pyzzle.resources.ExerciseSummary;
import com.maniacobra.pyzzle.resources.PyzzFileManager;
import com.maniacobra.pyzzle.utils.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javafx.scene.control.Alert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PyzzAnalyzer {
    private static final PyzzAnalyzer instance = new PyzzAnalyzer();

    public static PyzzAnalyzer getInstance() {
        return instance;
    }

    private AnalysisResult AnalyzeSingleFile(File file) {
        try {
            String strData = file.getName().endsWith(".json") ? PyzzFileManager.getInstance().readNormal(file) : PyzzFileManager.getInstance().decode(file);
            JSONParser parser = new JSONParser();
            JSONObject data = (JSONObject)parser.parse(strData);
            JSONObject completion = (JSONObject)data.get("completion");
            JSONArray exercises = (JSONArray)completion.get("exercises");
            JSONArray untouchedExercises = (JSONArray)data.get("exercises");
            String packName = (String)data.get("pack_name");
            int examMode = Utils.getInt(data, "strict_mode");
            UUID uuid = UUID.fromString((String)data.get("uuid"));
            String version = (String)data.get("pyzzle_version");
            float maxScore = 0.0f;
            for (Object obj : untouchedExercises) {
                JSONObject ex = (JSONObject)obj;
                float coef = Utils.getFloat(ex, "coef");
                maxScore += coef;
            }
            int nbWin = 0;
            int nbEmpty = 0;
            float totalScore = Utils.getFloat(completion, "total_score");
            int fileAttempts = Utils.getInt(completion, "attempt");
            String userName = (String)completion.get("user_name");
            ArrayList<ExerciseSummary> summaries = new ArrayList<ExerciseSummary>();
            for (Object obj : exercises) {
                JSONObject ex = (JSONObject)obj;
                if (ex.containsKey("empty")) {
                    ++nbEmpty;
                    continue;
                }
                float score = Utils.getFloat(ex, "score");
                boolean win = (Boolean)ex.get("win");
                int attemptsLeft = Utils.getInt(ex, "attempts");
                nbWin += win ? 1 : 0;
                summaries.add(new ExerciseSummary(score, win, attemptsLeft));
            }
            return new AnalysisResult(file.getName(), packName, examMode == 2, uuid, maxScore, version, userName, nbWin, nbEmpty, totalScore, fileAttempts, summaries);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error reading file : " + file.getName());
            return null;
        }
    }

    public boolean AnalyzeFiles(List<File> files) {
        boolean suspect = false;
        ArrayList<AnalysisResult> results = new ArrayList<AnalysisResult>();
        HashMap<String, UUID> packUUIDs = new HashMap<String, UUID>();
        File outDir = null;
        int success = 0;
        StringBuilder failures = new StringBuilder();
        for (File file : files) {
            AnalysisResult aResult;
            if (outDir == null) {
                outDir = file.getParentFile();
            }
            if ((aResult = this.AnalyzeSingleFile(file)) != null) {
                ++success;
                results.add(aResult);
                UUID uuid = (UUID)packUUIDs.get(aResult.packName());
                if (uuid == null) {
                    packUUIDs.put(aResult.packName(), aResult.uuid());
                    continue;
                }
                if (uuid.equals(aResult.uuid())) continue;
                System.out.printf("Incoherent UUID ! %s -> %s ; %s%n", aResult.packName(), uuid, aResult.uuid());
                suspect = true;
                continue;
            }
            failures.append(file.getName()).append("\n");
        }
        if (success == 0) {
            return false;
        }
        if (suspect) {
            Utils.systemAlert(Alert.AlertType.WARNING, "Fichiers suspects", "Plusieurs fichiers concernant le m\u00eame pack on des identifiants diff\u00e9rents, cela pourrait indiquer des tentatives de triche. Les identifiants seront affich\u00e9s dans la correction, comparez les fichiers avec noms de packs identiques mais identifiants diff\u00e9rents.");
        }
        StringBuilder outData = new StringBuilder();
        outData.append("Nom du fichier,Nom du pack,Nom de l'utilisateur,Exercices non commenc\u00e9s,Score,Score /20,Exercices complets,Nombre d'ouvertures du fichier,Examen ?,Version de Pyzzle");
        if (suspect) {
            outData.append(",Identifiants");
        }
        outData.append("\n");
        for (AnalysisResult aResult : results) {
            outData.append(String.format("%s,%s,%s,%d,%s,%s,%d,%d,%s,%s%s\n", aResult.fileName(), aResult.packName(), aResult.userName(), aResult.nbEmpty(), Utils.nbToStr(aResult.score()), Utils.nbToStr(aResult.getOutOf20()), aResult.nbWin(), aResult.fileAttempts(), aResult.version(), aResult.examMode() ? "Oui" : "Non", suspect ? "," + String.valueOf(aResult.uuid()) : ""));
        }
        String string = outDir.getAbsolutePath() + "/correction.csv";
        try (FileWriter outWriter = new FileWriter(string);){
            outWriter.write(outData.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Utils.systemAlert(Alert.AlertType.INFORMATION, "Correction effectu\u00e9e", "Fichier sauvegard\u00e9, vous pouvez l'ouvrir avec Excel ou autre logiciel : " + string + (String)(failures.isEmpty() ? "" : "\n\nATTENTION, il y a eu un probl\u00e8me lors du chargement de ces fichiers :\n\n" + String.valueOf(failures)));
        return true;
    }
}

