/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.utils;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javafx.scene.control.Alert;
import org.json.simple.JSONObject;

public class Utils {
    public static String nbToStr(float nb) {
        if ((float)((int)nb) == nb) {
            return String.valueOf((int)nb);
        }
        String[] splitted = String.valueOf(nb).split("\\.");
        if (splitted.length < 2) {
            return String.valueOf(nb);
        }
        String decimal = splitted[1];
        if (decimal.length() > 2) {
            decimal = decimal.substring(0, 1);
        }
        return splitted[0] + "." + decimal;
    }

    public static int getInt(JSONObject data, String key) {
        Object nb = data.get(key);
        if (nb instanceof Long) {
            return ((Long)nb).intValue();
        }
        return (Integer)nb;
    }

    public static float getFloat(JSONObject data, String key) {
        Object nb = data.get(key);
        if (nb instanceof Double) {
            return ((Double)nb).floatValue();
        }
        return ((Float)nb).floatValue();
    }

    public static void systemAlert(Alert.AlertType type, String title, String content) {
        Runnable runnable = (Runnable)Toolkit.getDefaultToolkit().getDesktopProperty("win.sound.exclamation");
        if (runnable != null) {
            runnable.run();
        }
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(content);
        alert.showAndWait();
    }

    public static String convertToFileName(String input) {
        String invalidChars = "[\\\\/:*?\"<>|]";
        String safeFileName = input.replaceAll(invalidChars, "_");
        safeFileName = safeFileName.trim();
        return safeFileName;
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            assert (children != null);
            for (String child : children) {
                Utils.copyDirectory(new File(sourceLocation, child), new File(targetLocation, child));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }
}

