/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.views;

import com.maniacobra.pyzzle.controllers.MainController;
import com.maniacobra.pyzzle.properties.AppSettings;
import com.maniacobra.pyzzle.properties.FilePaths;
import com.maniacobra.pyzzle.resources.CodeRunner;
import com.maniacobra.pyzzle.resources.IdsRegistry;
import com.maniacobra.pyzzle.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class PyzzleMain
extends Application {
    private static File fileArg;
    private static boolean shiftPressed;

    public static File getFileArg() {
        return fileArg;
    }

    public static boolean isShiftPressed() {
        return shiftPressed;
    }

    @Override
    public void start(Stage stage) throws IOException {
        if (!FilePaths.load()) {
            Utils.systemAlert(Alert.AlertType.ERROR, "Pyzzle : Impossible de d\u00e9marrer", "Pyzzle n'est pas parvenu \u00e0 pr\u00e9parer son d\u00e9marrage correctement, v\u00e9rifiez l'installation et les permissions du logiciel.");
            System.exit(1);
        }
        AppSettings.getInstance().load();
        IdsRegistry.getInstance().load();
        CodeRunner.getInstance().pythonTest();
        ClassLoader.getSystemClassLoader().setDefaultAssertionStatus(true);
        MainController controller = new MainController();
        FXMLLoader rootFxmlLoader = new FXMLLoader(PyzzleMain.class.getResource("main-view.fxml"));
        FXMLLoader welcomeFxmlLoader = new FXMLLoader(PyzzleMain.class.getResource("welcome-view.fxml"));
        rootFxmlLoader.setController(controller);
        welcomeFxmlLoader.setController(controller);
        BorderPane root = (BorderPane)rootFxmlLoader.load();
        Scene scene = new Scene(root);
        scene.getStylesheets().add(Objects.requireNonNull(PyzzleMain.class.getResource("style.css")).toExternalForm());
        stage.setMaximized(true);
        stage.setTitle("Pyzzle");
        stage.setScene(scene);
        scene.setOnKeyPressed(ke -> {
            if (ke.getCode().equals((Object)KeyCode.SHIFT)) {
                shiftPressed = true;
            }
        });
        scene.setOnKeyReleased(ke -> {
            if (ke.getCode().equals((Object)KeyCode.SHIFT)) {
                shiftPressed = false;
            }
        });
        Pane welcomePane = (Pane)welcomeFxmlLoader.load();
        root.setCenter(welcomePane);
        stage.show();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.out.println("Pyzzle opened with args :");
            for (String arg : args) {
                System.out.println(arg);
            }
            fileArg = new File(args[0]);
        }
        PyzzleMain.launch(new String[0]);
    }

    static {
        shiftPressed = false;
    }
}

