/*
 * Decompiled with CFR 0.152.
 */
package com.maniacobra.pyzzle.views.blockeditor;

import com.maniacobra.pyzzle.controllers.ExerciseController;
import com.maniacobra.pyzzle.models.Word;
import com.maniacobra.pyzzle.properties.AppSettings;
import com.maniacobra.pyzzle.properties.AppStyle;
import com.maniacobra.pyzzle.views.blockeditor.WordBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;

public class BlockEditor {
    private static final int sep = 6;
    private static final int margin = 15;
    private final Canvas canvas;
    private final GraphicsContext gc;
    private final ArrayList<ArrayList<WordBlock>> blocks = new ArrayList();
    private Stack<Integer> highlightedLines = null;
    private int previewLine = -1;
    private int previewPos = 0;
    private int previewPosPixels = 0;
    private boolean previewMakeLine = false;
    private boolean ignoreNextClick = false;
    private final boolean construction;
    private boolean locked = false;
    private boolean solution = false;
    private final EventHandler<MouseEvent> eventHandlerPressed;
    private final EventHandler<MouseEvent> eventHandlerExited;

    public BlockEditor(Canvas canvas, ExerciseController controller, boolean construction) {
        this.construction = construction;
        this.canvas = canvas;
        this.gc = canvas.getGraphicsContext2D();
        this.eventHandlerPressed = mouseEvent -> {
            if (this.locked) {
                return;
            }
            if (this.ignoreNextClick) {
                this.ignoreNextClick = false;
                return;
            }
            int x = (int)mouseEvent.getX();
            int y = (int)mouseEvent.getY();
            int i = 0;
            for (ArrayList<WordBlock> blockLine : this.blocks) {
                for (WordBlock block : blockLine) {
                    if (!block.collide(x, y)) continue;
                    boolean leftClick = mouseEvent.isPrimaryButtonDown();
                    boolean remove = false;
                    if (leftClick) {
                        controller.setSelectedBlock(block);
                        if (block.getWord().use() && construction) {
                            remove = true;
                        }
                    } else if (construction) {
                        controller.returnWord(block);
                        remove = true;
                    } else if (block.getWord().getUsages() != 0) {
                        block.getWord().use();
                        controller.quickInsertion(block);
                    }
                    if (remove) {
                        blockLine.remove(block);
                        if (blockLine.size() == 0) {
                            this.blocks.remove(blockLine);
                        }
                        this.updateLinesFrom(i);
                        controller.updateCode();
                    }
                    if (controller.hasSelectedBlock() && construction) {
                        this.previewPosition(x, y);
                    }
                    this.draw();
                    return;
                }
                ++i;
            }
        };
        this.eventHandlerExited = mouseEvent -> {
            if (this.locked) {
                return;
            }
            this.previewLine = -1;
            this.draw();
        };
        canvas.addEventFilter(MouseEvent.MOUSE_PRESSED, this.eventHandlerPressed);
        canvas.addEventFilter(MouseEvent.MOUSE_EXITED, this.eventHandlerExited);
    }

    public void fill(ArrayList<ArrayList<Word>> words) {
        int i = 0;
        for (List list : words) {
            this.fillLine(list, i);
            ++i;
        }
        this.draw();
    }

    private void fillLine(List<Word> wordLine, int lineNb) {
        ArrayList<Object> blockLine;
        if (lineNb >= this.blocks.size()) {
            blockLine = new ArrayList();
            this.blocks.add(blockLine);
        } else {
            blockLine = this.blocks.get(lineNb);
            blockLine.clear();
        }
        int x = 15;
        int y = lineNb * 27 + 15;
        for (Word word : wordLine) {
            WordBlock block = new WordBlock(word, x, y, this.gc, !this.construction);
            blockLine.add(block);
            x += block.getWidth() + 6;
        }
        this.highlightedLines = null;
    }

    public void previewPosition(int x, int y) {
        boolean oldMakeLine = this.previewMakeLine;
        int oldLine = this.previewLine;
        int oldPos = this.previewPos;
        float line = ((float)(y - 15) - 13.5f) / 27.0f;
        this.previewLine = (int)line;
        if (this.previewLine >= this.blocks.size()) {
            this.previewLine = this.blocks.size();
            this.previewMakeLine = true;
        } else if ((double)(line - (float)this.previewLine) < 0.2) {
            this.previewMakeLine = true;
        } else if ((double)(line - (float)this.previewLine) > 0.8) {
            ++this.previewLine;
            this.previewMakeLine = true;
        } else {
            this.previewMakeLine = false;
            ArrayList<WordBlock> blockLine = this.blocks.get(this.previewLine);
            int i = 0;
            this.previewPos = -1;
            for (WordBlock block : blockLine) {
                if (block.getX() + block.getWidth() / 2 > x) {
                    this.previewPos = i;
                    this.previewPosPixels = block.getX() - 3;
                    break;
                }
                ++i;
            }
            if (this.previewPos == -1 && blockLine.size() > 0) {
                this.previewPos = blockLine.size();
                WordBlock block = blockLine.get(blockLine.size() - 1);
                this.previewPosPixels = block.getX() + block.getWidth() + 3;
            }
        }
        if (oldMakeLine != this.previewMakeLine || oldLine != this.previewLine || oldPos != this.previewPos) {
            this.draw();
        }
    }

    public boolean insertWord(Word word) {
        if (this.previewLine == -1) {
            return false;
        }
        ArrayList<Word> wordLine = new ArrayList<Word>();
        if (this.previewLine >= this.blocks.size()) {
            wordLine.add(word);
            this.fillLine(wordLine, this.previewLine);
        } else if (this.previewMakeLine) {
            wordLine.add(word);
            this.blocks.add(this.previewLine, new ArrayList());
            this.fillLine(wordLine, this.previewLine);
            this.updateLinesFrom(this.previewLine + 1);
        } else {
            ArrayList<WordBlock> blockLine = this.blocks.get(this.previewLine);
            int i = 0;
            for (WordBlock block : blockLine) {
                if (i == this.previewPos) {
                    wordLine.add(word);
                }
                wordLine.add(block.getWord());
                ++i;
            }
            if (this.previewPos >= blockLine.size()) {
                wordLine.add(word);
            }
            this.fillLine(wordLine, this.previewLine);
        }
        if (!AppSettings.getInstance().dragAndDrop) {
            this.ignoreNextClick = true;
        }
        this.previewLine = -1;
        this.draw();
        return true;
    }

    public void returnWord(Word word) {
        for (ArrayList<WordBlock> blockLine : this.blocks) {
            for (WordBlock block : blockLine) {
                if (!block.getWord().merge(word)) continue;
                return;
            }
        }
    }

    public void quickInsertion(Word word) {
        ArrayList<Word> wordLine = new ArrayList<Word>();
        int lineNb = 0;
        if (this.blocks.size() > 0) {
            lineNb = this.blocks.size() - 1;
            ArrayList<WordBlock> blockLine = this.blocks.get(lineNb);
            for (WordBlock block : blockLine) {
                wordLine.add(block.getWord());
            }
        }
        wordLine.add(word);
        this.fillLine(wordLine, lineNb);
        this.draw();
    }

    public void quickNewLine(Word word) {
        ArrayList<Word> wordLine = new ArrayList<Word>();
        wordLine.add(word);
        this.fillLine(wordLine, this.blocks.size());
        this.draw();
    }

    public void decountWord(int id) {
        for (ArrayList<WordBlock> blockLine : this.blocks) {
            for (WordBlock block : blockLine) {
                if (block.getWord().getId() != id) continue;
                block.getWord().use();
                return;
            }
        }
        System.out.println(id + " not found.");
    }

    public void stopPreview() {
        if (this.previewLine != -1) {
            this.previewLine = -1;
            this.draw();
        }
        if (!AppSettings.getInstance().dragAndDrop) {
            this.ignoreNextClick = true;
        }
    }

    public String getFullText() {
        StringBuilder strBuilder = new StringBuilder();
        for (ArrayList<WordBlock> blockLine : this.blocks) {
            int i = 0;
            for (WordBlock block : blockLine) {
                strBuilder.append(block.getWord().getText());
                if (++i == blockLine.size()) continue;
                strBuilder.append(" ");
            }
            strBuilder.append("\n");
        }
        return strBuilder.toString();
    }

    public ArrayList<ArrayList<Integer>> getIds() {
        ArrayList<ArrayList<Integer>> ids = new ArrayList<ArrayList<Integer>>();
        for (ArrayList<WordBlock> blockLine : this.blocks) {
            ArrayList<Integer> line = new ArrayList<Integer>();
            ids.add(line);
            for (WordBlock block : blockLine) {
                line.add(block.getWord().getId());
            }
        }
        return ids;
    }

    public void setHighlightedLines(Stack<Integer> lines) {
        this.highlightedLines = lines;
    }

    public void draw() {
        this.gc.setFill(this.locked ? (this.solution ? AppStyle.Colors.canvasBackgroundSolution : AppStyle.Colors.canvasBackgroundLocked) : AppStyle.Colors.canvasBackground);
        this.gc.fillRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        if (this.highlightedLines != null) {
            for (Integer n : this.highlightedLines) {
                int y = 15 + n * 27 - 3;
                this.gc.setFill(AppStyle.Colors.highLighedLine);
                this.gc.fillRect(0.0, y, this.canvas.getWidth(), 27.0);
            }
        }
        for (ArrayList arrayList : this.blocks) {
            for (WordBlock block : arrayList) {
                block.draw(this.gc);
            }
        }
        if (this.previewLine == -1) {
            return;
        }
        this.gc.setFill(AppStyle.Colors.previewLine);
        int y = this.previewLine * 27;
        if (this.previewMakeLine) {
            this.gc.fillRect(0.0, (float)(y - 1 + 15) - 3.0f, this.canvas.getWidth(), 2.0);
        } else {
            this.gc.fillRect(this.previewPosPixels - 1, y + 15, 2.0, 21.0);
        }
    }

    public void lock(boolean solution) {
        this.solution = solution;
        this.locked = true;
        this.draw();
    }

    public void delete() {
        this.canvas.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.eventHandlerPressed);
        this.canvas.removeEventFilter(MouseEvent.MOUSE_EXITED, this.eventHandlerExited);
    }

    private void updateLinesFrom(int start) {
        ArrayList<Word> wordLine = new ArrayList<Word>();
        for (int i = start; i < this.blocks.size(); ++i) {
            wordLine.clear();
            ArrayList<WordBlock> blockLine = this.blocks.get(i);
            for (WordBlock block : blockLine) {
                wordLine.add(block.getWord());
            }
            this.fillLine(wordLine, i);
        }
    }
}

